/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.authorization;

import org.brapi.schematools.core.authorization.AuthorizationProvider;
import org.brapi.schematools.core.response.Response;

public final class BearerAuthorizationProvider
implements AuthorizationProvider {
    private final String token;

    @Override
    public boolean required() {
        return true;
    }

    @Override
    public Response<String> getAuthorization() {
        if (this.token == null) {
            return Response.fail(Response.ErrorType.VALIDATION, "Token was not provided!");
        }
        return Response.success("Bearer " + this.token);
    }

    BearerAuthorizationProvider(String token) {
        this.token = token;
    }

    public static BearerAuthorizationProviderBuilder builder() {
        return new BearerAuthorizationProviderBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BearerAuthorizationProvider)) {
            return false;
        }
        BearerAuthorizationProvider other = (BearerAuthorizationProvider)o;
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "BearerAuthorizationProvider(token=" + this.getToken() + ")";
    }

    public static class BearerAuthorizationProviderBuilder {
        private String token;

        BearerAuthorizationProviderBuilder() {
        }

        public BearerAuthorizationProviderBuilder token(String token) {
            this.token = token;
            return this;
        }

        public BearerAuthorizationProvider build() {
            return new BearerAuthorizationProvider(this.token);
        }

        public String toString() {
            return "BearerAuthorizationProvider.BearerAuthorizationProviderBuilder(token=" + this.token + ")";
        }
    }
}

