/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.graphql.options;

import java.util.HashMap;
import java.util.Map;
import org.brapi.schematools.core.graphql.options.IdsOptions;
import org.brapi.schematools.core.graphql.options.LinkType;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.model.BrAPIRelationshipType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.validiation.Validation;

public class PropertiesOptions
implements Options {
    private IdsOptions ids;
    private Map<String, Map<String, String>> linkTypeFor = new HashMap<String, Map<String, String>>();

    @Override
    public Validation validate() {
        return Validation.valid().merge(this.linkTypeFor.values().stream().flatMap(map -> map.values().stream()).map(LinkType::fromNameOrLabels).collect(Response.toList())).assertNotNull(this.ids, "'ids' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(PropertiesOptions overrideOptions) {
        if (overrideOptions.ids != null) {
            this.ids.override(overrideOptions.ids);
        }
        if (overrideOptions.linkTypeFor != null) {
            overrideOptions.linkTypeFor.forEach((key, value) -> {
                if (this.linkTypeFor.containsKey(key)) {
                    this.linkTypeFor.get(key).putAll((Map<String, String>)value);
                } else {
                    this.linkTypeFor.put((String)key, new HashMap(value));
                }
            });
        }
    }

    public LinkType getLinkTypeFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        Map<String, String> map = this.linkTypeFor.get(type.getName());
        if (map != null) {
            return LinkType.findByNameOrLabel(map.get(property.getName())).orElseGet(() -> this.getDefaultLinkTypeFor(type, property));
        }
        return this.getDefaultLinkTypeFor(type, property);
    }

    private LinkType getDefaultLinkTypeFor(BrAPIObjectType type, BrAPIObjectProperty property) {
        BrAPIRelationshipType relationshipType = property.getRelationshipType() != null ? property.getRelationshipType() : BrAPIRelationshipType.ONE_TO_ONE;
        return switch (relationshipType) {
            default -> throw new MatchException(null, null);
            case BrAPIRelationshipType.ONE_TO_ONE -> LinkType.EMBEDDED;
            case BrAPIRelationshipType.MANY_TO_ONE -> LinkType.EMBEDDED;
            case BrAPIRelationshipType.ONE_TO_MANY -> LinkType.EMBEDDED;
            case BrAPIRelationshipType.MANY_TO_MANY -> LinkType.SUB_QUERY;
        };
    }

    private Map<String, Map<String, String>> getLinkTypeFor() {
        return this.linkTypeFor;
    }

    public void setIds(IdsOptions ids) {
        this.ids = ids;
    }

    private PropertiesOptions() {
    }

    private PropertiesOptions(IdsOptions ids, Map<String, Map<String, String>> linkTypeFor) {
        this.ids = ids;
        this.linkTypeFor = linkTypeFor;
    }

    public IdsOptions getIds() {
        return this.ids;
    }

    private void setLinkTypeFor(Map<String, Map<String, String>> linkTypeFor) {
        this.linkTypeFor = linkTypeFor;
    }
}

