/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.comparator.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.brapi.schematools.core.openapi.comparator.options.AsciiDocRenderOptions;
import org.brapi.schematools.core.openapi.comparator.options.HTMLRenderOptions;
import org.brapi.schematools.core.openapi.comparator.options.JSONRenderOptions;
import org.brapi.schematools.core.openapi.comparator.options.MarkdownRenderOptions;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.ConfigurationUtils;
import org.brapi.schematools.core.validiation.Validation;

public class OpenAPIComparatorOptions
implements Options {
    private String tempFilePrefix;
    private AsciiDocRenderOptions asciiDoc;
    private HTMLRenderOptions html;
    private JSONRenderOptions json;
    private MarkdownRenderOptions markdown;
    private List<String> ignoreMissingEndpoints;
    private List<String> ignoreNewEndpoints;
    private Boolean ignoreDepreciatedEndpoints;

    public static OpenAPIComparatorOptions load() {
        try {
            return ConfigurationUtils.load("openapi-comparator-options.yaml", OpenAPIComparatorOptions.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OpenAPIComparatorOptions load(Path optionsFile) throws IOException {
        return OpenAPIComparatorOptions.load().override(ConfigurationUtils.load(optionsFile, OpenAPIComparatorOptions.class));
    }

    public static OpenAPIComparatorOptions load(InputStream inputStream) throws IOException {
        return OpenAPIComparatorOptions.load().override(ConfigurationUtils.load(inputStream, OpenAPIComparatorOptions.class));
    }

    public OpenAPIComparatorOptions override(OpenAPIComparatorOptions overrideOptions) {
        if (overrideOptions.tempFilePrefix != null) {
            this.tempFilePrefix = overrideOptions.tempFilePrefix;
        }
        if (overrideOptions.asciiDoc != null) {
            this.asciiDoc.override(overrideOptions.asciiDoc);
        }
        if (overrideOptions.html != null) {
            this.html.override(overrideOptions.html);
        }
        if (overrideOptions.json != null) {
            this.json.override(overrideOptions.json);
        }
        if (overrideOptions.markdown != null) {
            this.markdown.override(overrideOptions.markdown);
        }
        if (overrideOptions.ignoreMissingEndpoints != null) {
            this.ignoreMissingEndpoints = overrideOptions.ignoreMissingEndpoints;
        }
        if (overrideOptions.ignoreNewEndpoints != null) {
            this.ignoreNewEndpoints = overrideOptions.ignoreNewEndpoints;
        }
        if (overrideOptions.ignoreDepreciatedEndpoints != null) {
            this.ignoreDepreciatedEndpoints = overrideOptions.ignoreDepreciatedEndpoints;
        }
        return this;
    }

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.asciiDoc, "Ascii Doc Render Options are null", new Object[0]).assertNotNull(this.html, "HTML Render Options are null", new Object[0]).assertNotNull(this.json, "JSON Render Options are null", new Object[0]).assertNotNull(this.markdown, "Markdown Render Options are null", new Object[0]);
    }

    @JsonIgnore
    public boolean isIgnoringDeprecatedEndpoints() {
        return this.ignoreDepreciatedEndpoints != null ? this.ignoreDepreciatedEndpoints : false;
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public AsciiDocRenderOptions getAsciiDoc() {
        return this.asciiDoc;
    }

    public HTMLRenderOptions getHtml() {
        return this.html;
    }

    public JSONRenderOptions getJson() {
        return this.json;
    }

    public MarkdownRenderOptions getMarkdown() {
        return this.markdown;
    }

    public List<String> getIgnoreMissingEndpoints() {
        return this.ignoreMissingEndpoints;
    }

    public List<String> getIgnoreNewEndpoints() {
        return this.ignoreNewEndpoints;
    }

    public OpenAPIComparatorOptions setTempFilePrefix(String tempFilePrefix) {
        this.tempFilePrefix = tempFilePrefix;
        return this;
    }

    public OpenAPIComparatorOptions setIgnoreMissingEndpoints(List<String> ignoreMissingEndpoints) {
        this.ignoreMissingEndpoints = ignoreMissingEndpoints;
        return this;
    }

    public OpenAPIComparatorOptions setIgnoreNewEndpoints(List<String> ignoreNewEndpoints) {
        this.ignoreNewEndpoints = ignoreNewEndpoints;
        return this;
    }

    public OpenAPIComparatorOptions setIgnoreDepreciatedEndpoints(Boolean ignoreDepreciatedEndpoints) {
        this.ignoreDepreciatedEndpoints = ignoreDepreciatedEndpoints;
        return this;
    }

    private OpenAPIComparatorOptions() {
    }

    private OpenAPIComparatorOptions(String tempFilePrefix, AsciiDocRenderOptions asciiDoc, HTMLRenderOptions html, JSONRenderOptions json, MarkdownRenderOptions markdown, List<String> ignoreMissingEndpoints, List<String> ignoreNewEndpoints, Boolean ignoreDepreciatedEndpoints) {
        this.tempFilePrefix = tempFilePrefix;
        this.asciiDoc = asciiDoc;
        this.html = html;
        this.json = json;
        this.markdown = markdown;
        this.ignoreMissingEndpoints = ignoreMissingEndpoints;
        this.ignoreNewEndpoints = ignoreNewEndpoints;
        this.ignoreDepreciatedEndpoints = ignoreDepreciatedEndpoints;
    }

    private OpenAPIComparatorOptions setAsciiDoc(AsciiDocRenderOptions asciiDoc) {
        this.asciiDoc = asciiDoc;
        return this;
    }

    private OpenAPIComparatorOptions setHtml(HTMLRenderOptions html) {
        this.html = html;
        return this;
    }

    private OpenAPIComparatorOptions setJson(JSONRenderOptions json) {
        this.json = json;
        return this;
    }

    private OpenAPIComparatorOptions setMarkdown(MarkdownRenderOptions markdown) {
        this.markdown = markdown;
        return this;
    }
}

