/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.brapi.schematools.core.response.Response;

public class OpenAPIComponentsReader {
    public Response<Components> readComponents(Path schemaDirectory) {
        Components components = new Components();
        try {
            return Files.find(schemaDirectory, 3, this::schemaPathMatcher, new FileVisitOption[0]).map(this::readComponentFile).collect(Response.toList()).onSuccessDoWithResult(result -> result.forEach(c -> this.merge(components, (Components)c))).merge(Response.success(components));
        }
        catch (IOException | RuntimeException e) {
            return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
        }
    }

    private void merge(Components toComponents, Components fromComponents) {
        if (fromComponents.getParameters() != null) {
            fromComponents.getParameters().forEach((arg_0, arg_1) -> ((Components)toComponents).addParameters(arg_0, arg_1));
        }
        if (fromComponents.getResponses() != null) {
            fromComponents.getResponses().forEach((arg_0, arg_1) -> ((Components)toComponents).addResponses(arg_0, arg_1));
        }
        if (fromComponents.getSchemas() != null) {
            fromComponents.getSchemas().forEach((arg_0, arg_1) -> ((Components)toComponents).addSchemas(arg_0, arg_1));
        }
        if (fromComponents.getSecuritySchemes() != null) {
            fromComponents.getSecuritySchemes().forEach((arg_0, arg_1) -> ((Components)toComponents).addSecuritySchemes(arg_0, arg_1));
        }
    }

    private Response<Components> readComponentFile(Path path) {
        try {
            SwaggerParseResult result = new OpenAPIParser().readLocation(path.toFile().getPath(), null, null);
            return Response.success(result.getOpenAPI().getComponents());
        }
        catch (Exception e) {
            return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
        }
    }

    private boolean schemaPathMatcher(Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && path.toString().endsWith(".yaml");
    }
}

