/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.openapi.generator.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.brapi.schematools.core.metadata.Metadata;
import org.brapi.schematools.core.model.BrAPIType;

public class AbstractOpenAPIMetadata
implements Metadata {
    Map<String, String> summaries = new HashMap<String, String>();
    Map<String, String> descriptions = new HashMap<String, String>();

    public void override(AbstractOpenAPIMetadata overrideMetadata) {
        if (overrideMetadata.summaries != null) {
            this.summaries.putAll(overrideMetadata.summaries);
        }
        if (overrideMetadata.descriptions != null) {
            this.descriptions.putAll(overrideMetadata.descriptions);
        }
    }

    @JsonIgnore
    public final String getSummaryOrDefault(@NonNull String name, String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.summaries.getOrDefault(name, defaultValue);
    }

    @JsonIgnore
    public final String getSummaryOrDefault(@NonNull BrAPIType type, String defaultValue) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.summaries.getOrDefault(type.getName(), defaultValue);
    }

    @JsonIgnore
    public AbstractOpenAPIMetadata setSummaryFor(String name, String description) {
        this.summaries.put(name, description);
        return this;
    }

    @JsonIgnore
    public final String getDescriptionOrDefault(@NonNull String name, String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.descriptions.getOrDefault(name, defaultValue);
    }

    @JsonIgnore
    public final String getDescriptionOrDefault(@NonNull BrAPIType type, String defaultValue) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.getDescriptionOrDefault(type.getName(), defaultValue);
    }

    @JsonIgnore
    public AbstractOpenAPIMetadata setDescriptionFor(String name, String description) {
        this.descriptions.put(name, description);
        return this;
    }

    private void setSummaries(Map<String, String> summaries) {
        this.summaries = summaries;
    }

    private void setDescriptions(Map<String, String> descriptions) {
        this.descriptions = descriptions;
    }
}

