/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.brapi.schematools.core.model.BrAPIType;
import org.brapi.schematools.core.options.Options;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.validiation.Validation;

public class PropertyOptions
implements Options {
    private String nameFormat;
    private Boolean link;
    private Map<String, String> propertyFor = new HashMap<String, String>();
    private Map<String, String> pluralPropertyFor = new HashMap<String, String>();

    @Override
    public Validation validate() {
        return Validation.valid().assertNotNull(this.nameFormat, "'analyse' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.link, "'link' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.propertyFor, "'propertyFor' option on %s is null", this.getClass().getSimpleName()).assertNotNull(this.pluralPropertyFor, "'pluralPropertyFor' option on %s is null", this.getClass().getSimpleName());
    }

    public void override(PropertyOptions overrideOptions) {
        if (overrideOptions.nameFormat != null) {
            this.setNameFormat(overrideOptions.nameFormat);
        }
        if (overrideOptions.link != null) {
            this.setLink(overrideOptions.link);
        }
        this.propertyFor.putAll(overrideOptions.propertyFor);
        this.pluralPropertyFor.putAll(overrideOptions.pluralPropertyFor);
    }

    public boolean isLink() {
        return this.link != null && this.link != false;
    }

    @JsonIgnore
    public String getPropertyNameFor(String name) {
        return this.propertyFor.getOrDefault(name, String.format(this.nameFormat, StringUtils.toParameterCase(name)));
    }

    public String getPropertyNameFor(BrAPIType type) {
        return this.getPropertyNameFor(type.getName());
    }

    @JsonIgnore
    public PropertyOptions setPropertyNameFor(String name, String parameterName) {
        this.propertyFor.put(name, parameterName);
        return this;
    }

    @JsonIgnore
    public PropertyOptions setPropertyNameFor(BrAPIType type, String parameterName) {
        return this.setPropertyNameFor(type.getName(), parameterName);
    }

    @JsonIgnore
    public String getPluralPropertyNameFor(String name) {
        return this.propertyFor.getOrDefault(name, StringUtils.toPlural(String.format(this.nameFormat, StringUtils.toParameterCase(name))));
    }

    public String getPluralPropertyNameFor(BrAPIType type) {
        return this.getPluralPropertyNameFor(type.getName());
    }

    @JsonIgnore
    public PropertyOptions setPluralPropertyNameFor(String name, String parameterName) {
        this.propertyFor.put(name, parameterName);
        return this;
    }

    @JsonIgnore
    public PropertyOptions setPluralPropertyNameFor(BrAPIType type, String idParameter) {
        return this.setPluralPropertyNameFor(type.getName(), idParameter);
    }

    private String getNameFormat() {
        return this.nameFormat;
    }

    private Map<String, String> getPropertyFor() {
        return this.propertyFor;
    }

    private Map<String, String> getPluralPropertyFor() {
        return this.pluralPropertyFor;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    public void setLink(Boolean link) {
        this.link = link;
    }

    private PropertyOptions() {
    }

    private PropertyOptions(String nameFormat, Boolean link, Map<String, String> propertyFor, Map<String, String> pluralPropertyFor) {
        this.nameFormat = nameFormat;
        this.link = link;
        this.propertyFor = propertyFor;
        this.pluralPropertyFor = pluralPropertyFor;
    }

    public Boolean getLink() {
        return this.link;
    }

    private void setPropertyFor(Map<String, String> propertyFor) {
        this.propertyFor = propertyFor;
    }

    private void setPluralPropertyFor(Map<String, String> pluralPropertyFor) {
        this.pluralPropertyFor = pluralPropertyFor;
    }
}

