/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.atteo.evo.inflector.English;
import org.brapi.schematools.core.response.Response;

public class StringUtils {
    private static final Set<String> unpluralisables = ImmutableSet.of((Object)"germplasm");
    private static final List<Replacer> singularisations = ImmutableList.of((Object)StringUtils.replace("(.*)people$").with("$1person"), (Object)StringUtils.replace("(.*)People$").with("$1Person"), (Object)StringUtils.replace("oxen$").with("ox"), (Object)StringUtils.replace("children$").with("child"), (Object)StringUtils.replace("feet$").with("foot"), (Object)StringUtils.replace("teeth$").with("tooth"), (Object)StringUtils.replace("geese$").with("goose"), (Object)StringUtils.replace("(.*)ives?$").with("$1ife"), (Object)StringUtils.replace("(.*)ves?$").with("$1f"), (Object)StringUtils.replace("(.*)men$").with("$1man"), (Object)StringUtils.replace("(.+[aeiou])ys$").with("$1y"), (Object)StringUtils.replace("(.+[^aeiou])ies$").with("$1y"), (Object[])new Replacer[]{StringUtils.replace("(.+)zes$").with("$1"), StringUtils.replace("([m|l])ice$").with("$1ouse"), StringUtils.replace("(.+)matrices$").with("$1matrix"), StringUtils.replace("(.+)Matrices$").with("$1Matrix"), StringUtils.replace("indices$").with("index"), StringUtils.replace("(.+[^aeiou])ices$").with("$1ice"), StringUtils.replace("(.*)ices$").with("$1ex"), StringUtils.replace("(octop|vir)i$").with("$1us"), StringUtils.replace("bases$").with("base"), StringUtils.replace("(.+(s|x|sh|ch))es$").with("$1"), StringUtils.replace("(.+)s$").with("$1")});
    private static final List<Replacer> pluralisations = ImmutableList.of((Object)StringUtils.replace("(.*)matrix$").with("$1matrices"), (Object)StringUtils.replace("(.*)Matrix$").with("$1Matrices"), (Object)StringUtils.replace("(.*)person$").with("$1people"), (Object)StringUtils.replace("(.*)Person$").with("$1People"));

    public static String capitalise(String value) {
        return value != null ? value.substring(0, 1).toUpperCase() + value.substring(1) : null;
    }

    public static String toSingular(String value) {
        if (value == null) {
            return null;
        }
        if (unpluralisables.contains(value.toLowerCase())) {
            return value;
        }
        for (Replacer singularization : singularisations) {
            if (!singularization.matches(value)) continue;
            return singularization.replace();
        }
        return value;
    }

    public static String toPlural(String value) {
        if (value == null) {
            return null;
        }
        if (unpluralisables.contains(value.toLowerCase())) {
            return value;
        }
        for (Replacer pluralisation : pluralisations) {
            if (!pluralisation.matches(value)) continue;
            return pluralisation.replace();
        }
        return English.plural((String)value);
    }

    public static String makeValidName(String string) {
        if (string == null) {
            return "null";
        }
        if (((String)string).isBlank()) {
            return "blank";
        }
        if (((String)string).matches("^\\d.*$")) {
            string = "N" + (String)string;
        }
        return ((String)string).replace("-", "_").replace("/", "_").replace(".", "_");
    }

    public static String toSentenceCase(String value) {
        return value != null ? value.substring(0, 1).toUpperCase() + value.substring(1) : null;
    }

    public static String toParameterCase(String value) {
        return value != null ? value.substring(0, 1).toLowerCase() + value.substring(1) : null;
    }

    public static String toLowerCase(String value) {
        return value != null ? value.toLowerCase() : null;
    }

    public static boolean startsWithLowerCase(String value) {
        return value != null && value.matches("^[a-z].*$");
    }

    public static boolean startsWithUpperCase(String value) {
        return value != null && value.matches("^[A-Z].*$");
    }

    public static String toLabel(String propertyName) {
        return StringUtils.capitalise(propertyName).replaceAll("([A-Z])", " $1").trim();
    }

    public static Response<String> readStringFromClasspath(String classpath) {
        try {
            URL url = StringUtils.class.getClassLoader().getResource(classpath);
            if (url != null) {
                return StringUtils.readStringFromPath(Paths.get(url.toURI()));
            }
            return Response.fail(Response.ErrorType.VALIDATION, String.format("Could not find resource on classpath '%s'", classpath));
        }
        catch (URISyntaxException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, exception.getMessage());
        }
    }

    public static Response<String> readStringFromPath(Path path) {
        try {
            Stream<String> lines = Files.lines(path);
            String data = lines.collect(Collectors.joining("\n"));
            lines.close();
            return Response.success(data);
        }
        catch (IOException exception) {
            return Response.fail(Response.ErrorType.VALIDATION, exception.getMessage());
        }
    }

    public static boolean isNotBlank(String string) {
        return string != null && !string.isBlank();
    }

    public static boolean isMultilineEqual(String expected, String actual) {
        BufferedReader expectedReader = new BufferedReader(new StringReader(expected));
        BufferedReader actualReader = new BufferedReader(new StringReader(actual));
        boolean equals = true;
        try {
            String expectedLine = expectedReader.readLine();
            String actualLine = actualReader.readLine();
            while (equals && expectedLine != null && actualLine != null) {
                equals = expectedLine.equals(actualLine);
                expectedLine = expectedReader.readLine();
                actualLine = actualReader.readLine();
            }
            equals = equals && expectedLine == null && actualLine == null;
        }
        catch (Exception e) {
            equals = false;
        }
        return equals;
    }

    public static boolean isJSONEqual(String expected, String actual) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readTree(expected).equals((Object)mapper.readTree(actual));
    }

    public static String prettyPrint(Object value) throws JsonProcessingException {
        return StringUtils.prettyPrint(value, 4);
    }

    public static String prettyPrint(Object value, int indent) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        DefaultIndenter indenter = new DefaultIndenter(" ".repeat(indent), DefaultIndenter.SYS_LF);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        return mapper.writer((PrettyPrinter)printer).writeValueAsString(value);
    }

    public static String format(String format, Map<String, Object> parameters) {
        if (format == null) {
            return null;
        }
        StringBuilder newFormat = new StringBuilder(format);
        ArrayList<Object> valueList = new ArrayList<Object>();
        Matcher matcher = Pattern.compile("[$][{](\\w+)}").matcher(format);
        while (matcher.find()) {
            String key = matcher.group(1);
            String paramName = "${" + key + "}";
            int index = newFormat.indexOf(paramName);
            if (index == -1) continue;
            newFormat.replace(index, index + paramName.length(), "%s");
            valueList.add(parameters.get(key));
        }
        return String.format(newFormat.toString(), valueList.toArray());
    }

    static Replacer.Builder replace(String pattern) {
        return new Replacer.Builder(Pattern.compile(pattern));
    }

    static class Replacer {
        final Pattern pattern;
        final String replacement;
        Matcher m;

        private Replacer(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        boolean matches(String word) {
            this.m = this.pattern.matcher(word);
            return this.m.matches();
        }

        String replace() {
            return this.m.replaceFirst(this.replacement);
        }

        static class Builder {
            private final Pattern pattern;

            Builder(Pattern pattern) {
                this.pattern = pattern;
            }

            Replacer with(String replacement) {
                return new Replacer(this.pattern, replacement);
            }
        }
    }
}

