/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.validiation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.validiation.Validatable;

public class Validation {
    List<Response.Error> errors = new ArrayList<Response.Error>();

    public static Validation valid() {
        return new Validation();
    }

    public Validation assertNotNull(Object value, String errorMessage, Object ... args) {
        if (value == null) {
            this.addError(errorMessage, args);
        }
        return this;
    }

    public Validation assertMutuallyExclusive(Object value, String ... properties) {
        if (value == null) {
            this.addError("Value is null!");
        } else {
            int count = 0;
            for (String property : properties) {
                try {
                    if (PropertyUtils.getProperty((Object)value, (String)property) == null) continue;
                    ++count;
                }
                catch (Exception e) {
                    this.addError(e);
                }
            }
            if (count > 1) {
                this.addError("Only one of '%s' can be provided", String.join((CharSequence)", ", Arrays.asList(properties)));
            }
        }
        return this;
    }

    public Validation assertClass(Object value, List<Class<?>> classes) {
        if (value != null && classes.stream().noneMatch(aClass -> value.getClass().isAssignableFrom((Class<?>)aClass))) {
            this.addError("Value must one of '%s', but was '%s'", classes.stream().map(Class::getName).collect(Collectors.joining(", ")), value.getClass().getName());
        }
        return this;
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public Validation merge(Validatable validatable) {
        if (validatable != null) {
            this.addAllErrors(validatable.validate().getErrors());
        } else {
            this.addError("Can not merge null Validatable!");
        }
        return this;
    }

    public Validation merge(Response<?> response) {
        if (response != null) {
            this.addAllErrors(response.getAllErrors());
        } else {
            this.addError("Can not merge null Validatable!");
        }
        return this;
    }

    public Validation merge(Validatable validatable, String prefixMessage) {
        if (validatable != null) {
            this.addAllErrors(validatable.validate().getErrors(), prefixMessage);
        } else {
            this.addError("Can not merge null Validatable!");
        }
        return this;
    }

    public Validation mergeOnCondition(boolean condition, Validatable validatable) {
        if (condition) {
            if (validatable != null) {
                this.addAllErrors(validatable.validate().getErrors());
            } else {
                this.addError("Can not merge null Validatable!");
            }
        }
        return this;
    }

    public Validation mergeOnCondition(boolean condition, Validatable validatable, String prefixMessage) {
        if (condition) {
            if (validatable != null) {
                this.addAllErrors(validatable.validate().getErrors(), prefixMessage);
            } else {
                this.addError("Can not merge null Validatable!");
            }
        }
        return this;
    }

    public List<String> getErrorMessages() {
        return this.errors.stream().map(Response.Error::getMessage).toList();
    }

    public String getAllErrorsMessage() {
        if (this.errors.isEmpty()) {
            return null;
        }
        return this.errors.stream().map(Response.Error::getMessage).collect(Collectors.joining(", "));
    }

    public <T extends Validatable> Validation merge(List<T> validatableList) {
        if (validatableList != null) {
            validatableList.stream().map(Validatable::validate).map(Validation::getErrors).forEach(this::addAllErrors);
        }
        return this;
    }

    public <U> Response<U> asResponse() {
        if (this.errors.isEmpty()) {
            return Response.empty();
        }
        return Response.empty().merge(this);
    }

    private void addError(String errorMessage, Object ... args) {
        String message = args != null && args.length > 0 ? String.format(errorMessage, args) : errorMessage;
        this.errors.add(Response.Error.of("", message, Response.ErrorType.VALIDATION));
    }

    private void addError(String message) {
        this.errors.add(Response.Error.of("", message, Response.ErrorType.VALIDATION));
    }

    private void addError(Exception e) {
        this.errors.add(Response.Error.of("", e.getMessage(), Response.ErrorType.VALIDATION));
    }

    private void addAllErrors(Collection<Response.Error> errors) {
        this.errors.addAll(errors);
    }

    private void addAllErrors(Collection<Response.Error> errors, String prefixMessage) {
        errors.forEach(error -> this.errors.add(Response.Error.of(error.getCode(), String.format("%s %s", prefixMessage, error.getMessage()), error.getType())));
    }

    public List<Response.Error> getErrors() {
        return this.errors;
    }
}

