/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.schematools.core.xlsx;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.brapi.schematools.core.brapischema.BrAPISchemaReader;
import org.brapi.schematools.core.model.BrAPIClass;
import org.brapi.schematools.core.model.BrAPIObjectProperty;
import org.brapi.schematools.core.model.BrAPIObjectType;
import org.brapi.schematools.core.response.Response;
import org.brapi.schematools.core.utils.BrAPIClassCacheUtil;
import org.brapi.schematools.core.utils.StringUtils;
import org.brapi.schematools.core.xlsx.options.ColumnOption;
import org.brapi.schematools.core.xlsx.options.ValuePropertyOption;
import org.brapi.schematools.core.xlsx.options.XSSFWorkbookGeneratorOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSSFWorkbookGenerator {
    private static final Logger log = LoggerFactory.getLogger(XSSFWorkbookGenerator.class);
    private final BrAPISchemaReader schemaReader;
    private final XSSFWorkbookGeneratorOptions options;
    private Path outputPath;

    public XSSFWorkbookGenerator(Path outputPath) {
        this(new BrAPISchemaReader(), XSSFWorkbookGeneratorOptions.load(), outputPath);
    }

    public XSSFWorkbookGenerator(XSSFWorkbookGeneratorOptions options, Path outputPath) {
        this(new BrAPISchemaReader(), options, outputPath);
    }

    public Response<List<Path>> generate(Path schemaDirectory) {
        return this.schemaReader.readDirectories(schemaDirectory).mapResultToResponse(brAPISchemas -> new Generator((List<BrAPIClass>)brAPISchemas).generate());
    }

    public XSSFWorkbookGenerator(BrAPISchemaReader schemaReader, XSSFWorkbookGeneratorOptions options, Path outputPath) {
        this.schemaReader = schemaReader;
        this.options = options;
        this.outputPath = outputPath;
    }

    private class Generator {
        private final Map<String, BrAPIClass> brAPIClasses;

        public Generator(List<BrAPIClass> brAPISchemas) {
            this.brAPIClasses = new BrAPIClassCacheUtil(this::isGenerating).createMap(brAPISchemas);
        }

        public Response<List<Path>> generate() {
            try {
                return this.generateDataClasses(new ArrayList<BrAPIClass>(this.brAPIClasses.values()));
            }
            catch (Exception e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private boolean isGenerating(BrAPIClass brAPIClass) {
            return brAPIClass.getMetadata() == null || !brAPIClass.getMetadata().isRequest() && !brAPIClass.getMetadata().isParameters();
        }

        private Response<List<Path>> generateDataClasses(List<BrAPIClass> brAPIClasses) {
            XSSFWorkbook workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet("Data Classes");
            this.createHeaderRow((Workbook)workbook, sheet, XSSFWorkbookGenerator.this.options.getDataClassProperties());
            this.createRows(sheet, 1, null, XSSFWorkbookGenerator.this.options.getDataClassProperties(), brAPIClasses);
            this.formatSheet(sheet, brAPIClasses.size());
            sheet = workbook.createSheet("Data Classes Fields");
            this.createHeaderRow((Workbook)workbook, sheet, XSSFWorkbookGenerator.this.options.getDataClassFieldProperties(), XSSFWorkbookGenerator.this.options.getDataClassFieldHeaders());
            this.createRows(sheet, 1, this::getHeaders, XSSFWorkbookGenerator.this.options.getDataClassFieldProperties(), brAPIClasses, this::findFields);
            this.formatSheet(sheet, brAPIClasses.size());
            return this.saveWorkbook((Workbook)workbook, XSSFWorkbookGenerator.this.outputPath).mapResult(Collections::singletonList);
        }

        private List<String> getHeaders(BrAPIClass brAPIClass) {
            return Arrays.asList(brAPIClass.getName(), brAPIClass.getModule());
        }

        private List<BrAPIObjectProperty> findFields(BrAPIClass brAPIClass) {
            ArrayList<BrAPIObjectProperty> properties = new ArrayList<BrAPIObjectProperty>();
            if (brAPIClass instanceof BrAPIObjectType) {
                BrAPIObjectType brAPIObjectType = (BrAPIObjectType)brAPIClass;
                return brAPIObjectType.getProperties();
            }
            return properties;
        }

        private Response<Path> saveWorkbook(Workbook workbook, Path path) {
            try {
                FileOutputStream outputStream = new FileOutputStream(path.toFile());
                workbook.write((OutputStream)outputStream);
                workbook.close();
                return Response.success(path);
            }
            catch (IOException e) {
                return Response.fail(Response.ErrorType.VALIDATION, e.getMessage());
            }
        }

        private void formatSheet(Sheet sheet, int lastIndex) {
            CellRangeAddress ca = new CellRangeAddress(0, lastIndex, (int)sheet.getRow(0).getFirstCellNum(), sheet.getRow(0).getLastCellNum() - 1);
            sheet.setAutoFilter(ca);
        }

        private void createHeaderRow(Workbook workbook, Sheet sheet, List<ColumnOption> columns) {
            this.createHeaderRow(workbook, sheet, columns, null);
        }

        private void createHeaderRow(Workbook workbook, Sheet sheet, List<ColumnOption> columns, List<String> headers) {
            Row headerRow = sheet.createRow(0);
            CellStyle headerStyle = this.createHeaderStyle(workbook);
            AtomicInteger columnIndex = new AtomicInteger(0);
            if (headers != null) {
                headers.forEach(header -> {
                    sheet.setColumnWidth(columnIndex.get(), 6000);
                    Cell headerCell = headerRow.createCell(columnIndex.getAndIncrement());
                    headerCell.setCellValue(header);
                    headerCell.setCellStyle(headerStyle);
                });
            }
            for (ColumnOption column : columns) {
                sheet.setColumnWidth(columnIndex.get(), 6000);
                Cell headerCell = headerRow.createCell(columnIndex.getAndIncrement());
                headerCell.setCellValue(column.getLabel() != null ? column.getLabel() : StringUtils.toLabel(column.getName()));
                headerCell.setCellStyle(headerStyle);
            }
        }

        private CellStyle createHeaderStyle(Workbook workbook) {
            CellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            headerStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            XSSFFont font = ((XSSFWorkbook)workbook).createFont();
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)12);
            font.setBold(true);
            headerStyle.setFont((Font)font);
            return headerStyle;
        }

        private <T> int createRows(Sheet sheet, int startIndex, List<String> headers, List<ColumnOption> columns, List<T> values) {
            int rowIndex = startIndex;
            for (T value : values) {
                this.createRow(sheet, columns, rowIndex, headers, value);
                ++rowIndex;
            }
            return rowIndex;
        }

        private <T, V> void createRows(Sheet sheet, int startIndex, Function<T, List<String>> headerFunction, List<ColumnOption> columns, List<T> values, Function<T, List<V>> valuesFunction) {
            int rowIndex = startIndex;
            for (T value : values) {
                rowIndex = this.createRows(sheet, rowIndex, headerFunction.apply(value), columns, valuesFunction.apply(value));
            }
        }

        private <T> void createRow(Sheet sheet, List<ColumnOption> columns, int rowIndex, List<String> headers, T bean) {
            Row row = sheet.createRow(rowIndex);
            AtomicInteger columnIndex = new AtomicInteger(0);
            if (headers != null) {
                headers.forEach(header -> {
                    Cell cell = row.createCell(columnIndex.getAndIncrement());
                    cell.setCellValue(header);
                });
            }
            for (ColumnOption column : columns) {
                try {
                    this.updateCellValue(row.createCell(columnIndex.getAndIncrement()), column, column.getDefaultValue(), rowIndex, PropertyUtils.getProperty(bean, (String)column.getName()));
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    log.warn(String.format("Error parsing bean with property '%s', at index '%d' due to '%s'", column.getName(), rowIndex, e.getMessage()));
                }
            }
        }

        private <T> void updateCellValue(Cell cell, ValuePropertyOption column, Object defaultValue, int rowIndex, Object value) {
            try {
                if (value instanceof Boolean) {
                    Boolean booleanValue = (Boolean)value;
                    cell.setCellValue(booleanValue.booleanValue());
                } else if (value instanceof Integer) {
                    Integer integerValue = (Integer)value;
                    cell.setCellValue((double)integerValue.intValue());
                } else if (value instanceof Double) {
                    Double doubleValue = (Double)value;
                    cell.setCellValue(doubleValue.doubleValue());
                } else if (value instanceof List) {
                    List listValue = (List)value;
                    if (column.getIndex() != null) {
                        this.updateCellValue(cell, column, defaultValue, rowIndex, listValue.get(column.getIndex()));
                    } else {
                        cell.setCellValue(listValue.stream().collect(Collectors.joining(", ")).toString());
                    }
                } else if (value instanceof Map) {
                    Map mapValue = (Map)value;
                    if (column.getKey() != null) {
                        this.updateCellValue(cell, column, defaultValue, rowIndex, mapValue.get(column.getKey()));
                    } else {
                        cell.setCellValue(mapValue.entrySet().stream().collect(Collectors.joining(", ")).toString());
                    }
                } else if (value != null) {
                    if (column.getChildProperty() != null) {
                        this.updateCellValue(cell, column.getChildProperty(), defaultValue, rowIndex, PropertyUtils.getProperty((Object)value, (String)column.getChildProperty().getName()));
                    } else {
                        cell.setCellValue(value.toString());
                    }
                } else if (column.getDefaultValue() != null) {
                    this.updateCellValue(cell, column, null, rowIndex, column.getDefaultValue());
                } else if (defaultValue != null) {
                    this.updateCellValue(cell, column, null, rowIndex, defaultValue);
                }
            }
            catch (Exception e) {
                log.warn(String.format("Error parsing bean with property '%s', at row index '%d' due to '%s'", column.getName(), rowIndex, e.getMessage()));
            }
        }
    }
}

