/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.usecasechecker;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.brapi.usecasechecker.UseCaseChecker;
import org.brapi.usecasechecker.exceptions.UseCaseAdditionException;
import org.brapi.usecasechecker.model.useCases.App;
import org.brapi.usecasechecker.model.useCases.UseCase;
import org.brapi.usecasechecker.model.useCases.UseCases;

public class UseCaseCheckerFactory {
    private static UseCaseCheckerFactory instance;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private UseCases loadedUseCases = this.loadUseCases();

    private UseCaseCheckerFactory() {
    }

    private UseCases loadUseCases() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("useCases.json");
        UseCases useCases = null;
        try {
            useCases = (UseCases)this.objectMapper.readValue(is, UseCases.class);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        return useCases;
    }

    public static UseCaseCheckerFactory getInstance() {
        if (instance == null) {
            instance = new UseCaseCheckerFactory();
        }
        return instance;
    }

    public UseCaseChecker getUseCaseChecker(String baseUrl) {
        return new UseCaseChecker(baseUrl, this.loadedUseCases, this.objectMapper);
    }

    public void addUseCasesForApp(String appName, List<UseCase> useCasesToAdd) throws UseCaseAdditionException {
        Optional<App> app = this.loadedUseCases.getApps().stream().filter(a -> a.getAppName().equals(appName)).findFirst();
        if (!app.isPresent()) {
            throw new UseCaseAdditionException(String.format("Unable to add use case to app with name [%s] because no such app exists with that name", appName));
        }
        app.get().getUseCases().addAll(useCasesToAdd);
    }

    public void addAppWithUseCases(App app) throws UseCaseAdditionException {
        if (app.getUseCases() == null || app.getUseCases().isEmpty()) {
            throw new UseCaseAdditionException("No use cases added to submitted app");
        }
        if (app.getAppName() == null || app.getAppName().isEmpty()) {
            throw new UseCaseAdditionException("No app name in submitted app");
        }
        this.loadedUseCases.getApps().add(app);
    }

    public String exportLoadedUseCasesAsJsonString() throws JsonProcessingException {
        return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.loadedUseCases);
    }
}

