/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.usecasechecker.model.useCases;

import java.util.List;
import org.brapi.usecasechecker.exceptions.UseCaseBuilderException;
import org.brapi.usecasechecker.model.useCases.UseCase;

public class App {
    List<UseCase> useCases;
    String appName;

    public App() {
    }

    private App(Builder builder) {
        this.appName = builder.appName;
        this.useCases = builder.useCases;
    }

    public List<UseCase> getUseCases() {
        return this.useCases;
    }

    public void setUseCases(List<UseCase> useCases) {
        this.useCases = useCases;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public static class Builder {
        private String appName;
        private List<UseCase> useCases;

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder useCases(List<UseCase> useCases) {
            this.useCases = useCases;
            return this;
        }

        public App build() {
            if (this.appName == null || this.appName.isEmpty()) {
                throw new UseCaseBuilderException("No appName provided to builder");
            }
            if (this.useCases == null || this.useCases.isEmpty()) {
                throw new UseCaseBuilderException("No useCases provided to builder");
            }
            return new App(this);
        }
    }
}

