/*
 * Decompiled with CFR 0.152.
 */
package org.brapi.usecasechecker.model.useCases;

import java.util.List;
import org.brapi.usecasechecker.exceptions.UseCaseBuilderException;

public class ServiceRequired {
    private String serviceName;
    private List<String> methodsRequired;
    private String versionRequired;

    public ServiceRequired() {
    }

    private ServiceRequired(Builder builder) {
        this.serviceName = builder.serviceName;
        this.methodsRequired = builder.methodsRequired;
        this.versionRequired = builder.versionRequired;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public List<String> getMethodsRequired() {
        return this.methodsRequired;
    }

    public void setMethodsRequired(List<String> methodsRequired) {
        this.methodsRequired = methodsRequired;
    }

    public String getVersionRequired() {
        return this.versionRequired;
    }

    public void setVersionRequired(String versionRequired) {
        this.versionRequired = versionRequired;
    }

    public static class Builder {
        private String serviceName;
        private List<String> methodsRequired;
        private String versionRequired;

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder methodsRequired(List<String> methodsRequired) {
            this.methodsRequired = methodsRequired;
            return this;
        }

        public Builder versionRequired(String versionRequired) {
            this.versionRequired = versionRequired;
            return this;
        }

        public ServiceRequired build() {
            if (this.versionRequired == null || this.versionRequired.isEmpty()) {
                throw new UseCaseBuilderException("No versionRequired provided to builder.");
            }
            if (this.serviceName == null || this.serviceName.isEmpty()) {
                throw new UseCaseBuilderException("No serviceName provided to builder.");
            }
            if (this.methodsRequired == null || this.methodsRequired.isEmpty()) {
                throw new UseCaseBuilderException("No methodsRequired provided to builder.");
            }
            return new ServiceRequired(this);
        }
    }
}

