/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.util.Arrays;
import java.util.List;

final class Bytes {
    private static final char[] NYBBLES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void setU16(byte[] byArray, int n, short s) {
        byArray[n] = (byte)(s >> 8 & 0xFF);
        byArray[n + 1] = (byte)(s & 0xFF);
    }

    public static void setU32(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
        byArray[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byArray[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byArray[n + 3] = (byte)(n2 & 0xFF);
    }

    public static int getU32(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static String getU32S(byte[] byArray, int n) {
        return String.valueOf((long)Bytes.getU32(byArray, n) & 0xFFFFFFFFL);
    }

    public static int getU16(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    public static String getNulTerminatedStr(byte[] byArray, int n) {
        int n2;
        int n3 = byArray.length - n;
        for (n2 = 0; n2 < n3 && byArray[n + n2] != 0; ++n2) {
        }
        return new String(byArray, n, n2);
    }

    public static void splitStr(List<String> list, byte[] byArray, int n, byte by) {
        while (n < byArray.length && byArray[n] != 0) {
            int n2 = 0;
            while (n + n2 < byArray.length && byArray[n + n2] != 0 && byArray[n + n2] != by) {
                ++n2;
            }
            if (n2 > 0) {
                list.add(new String(byArray, n, n2));
            }
            if (byArray[n += n2] != by) continue;
            ++n;
        }
    }

    public static List<String> splitStr(List<String> list, String string) {
        String[] stringArray = string.split(" ", -1);
        if (list == null) {
            list = Arrays.asList(stringArray);
        } else {
            list.addAll(Arrays.asList(stringArray));
        }
        return list;
    }

    public static String hex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            int n = by & 0xFF;
            stringBuilder.append(NYBBLES[n >> 4]);
            stringBuilder.append(NYBBLES[n & 0xF]);
        }
        return stringBuilder.toString();
    }

    private Bytes() {
    }
}

