/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.freehaven.tor.control.Bytes;
import net.freehaven.tor.control.ConfigEntry;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlCommands;
import net.freehaven.tor.control.TorControlException;
import net.freehaven.tor.control.TorControlSyntaxException;
import net.freehaven.tor.control.TorNotRunningException;

public class TorControlConnection
implements TorControlCommands {
    private final LinkedList<Waiter> waiters;
    private final BufferedReader input;
    private final Writer output;
    private ControlParseThread thread;
    private volatile EventHandler handler;
    private volatile PrintWriter debugOutput;
    private volatile IOException parseThreadException;

    public TorControlConnection(Socket socket) throws IOException {
        this(socket.getInputStream(), socket.getOutputStream());
    }

    public TorControlConnection(InputStream inputStream, OutputStream outputStream) {
        this(new InputStreamReader(inputStream), new OutputStreamWriter(outputStream));
    }

    public TorControlConnection(Reader reader, Writer writer) {
        this.output = writer;
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.waiters = new LinkedList();
    }

    protected final void writeEscaped(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith(".")) {
                string2 = "." + string2;
            }
            string2 = string2.endsWith("\r") ? string2 + "\n" : string2 + "\r\n";
            if (this.debugOutput != null) {
                this.debugOutput.print(">> " + string2);
            }
            this.output.write(string2);
        }
        this.output.write(".\r\n");
        if (this.debugOutput != null) {
            this.debugOutput.print(">> .\n");
        }
    }

    protected static String quote(String string) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\"': 
                case '\\': {
                    stringBuilder.append('\\');
                }
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    protected final ArrayList<ReplyLine> readReply() throws IOException {
        char c;
        ArrayList<ReplyLine> arrayList = new ArrayList<ReplyLine>();
        do {
            String string;
            if ((string = this.input.readLine()) == null) {
                if (arrayList.isEmpty()) {
                    return arrayList;
                }
                throw new TorControlSyntaxException("Connection to Tor  broke down while receiving reply!");
            }
            if (this.debugOutput != null) {
                this.debugOutput.println("<< " + string);
            }
            if (string.length() < 4) {
                throw new TorControlSyntaxException("Line (\"" + string + "\") too short");
            }
            String string2 = string.substring(0, 3);
            c = string.charAt(3);
            String string3 = string.substring(4);
            String string4 = null;
            if (c == '+') {
                StringBuilder stringBuilder = new StringBuilder();
                while (true) {
                    string = this.input.readLine();
                    if (this.debugOutput != null) {
                        this.debugOutput.print("<< " + string);
                    }
                    if (string.equals(".")) break;
                    if (string.startsWith(".")) {
                        string = string.substring(1);
                    }
                    stringBuilder.append(string).append('\n');
                }
                string4 = stringBuilder.toString();
            }
            arrayList.add(new ReplyLine(string2, string3, string4));
        } while (c != ' ');
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<ReplyLine> sendAndWaitForResponse(String string, String string2) throws IOException {
        if (this.parseThreadException != null) {
            throw this.parseThreadException;
        }
        this.checkThread();
        Waiter waiter = new Waiter();
        if (this.debugOutput != null) {
            this.debugOutput.print(">> " + string);
        }
        List<Object> list = this.waiters;
        synchronized (list) {
            this.output.write(string);
            if (string2 != null) {
                this.writeEscaped(string2);
            }
            this.output.flush();
            this.waiters.addLast(waiter);
        }
        try {
            list = waiter.getResponse();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted");
        }
        for (ReplyLine replyLine : list) {
            if (replyLine.status.startsWith("2")) continue;
            throw new TorControlException("Error reply: " + replyLine.msg);
        }
        return list;
    }

    protected void handleEvent(ArrayList<ReplyLine> arrayList) {
        if (this.handler == null) {
            return;
        }
        for (ReplyLine replyLine : arrayList) {
            List<String> list;
            String string;
            String string2;
            int n = replyLine.msg.indexOf(32);
            if (n == -1) {
                string2 = replyLine.msg;
                string = "";
            } else {
                string2 = replyLine.msg.substring(0, n).toUpperCase();
                string = replyLine.msg.substring(n + 1);
            }
            if (string2.equals("CIRC")) {
                this.handler.circuitStatus(list.get(1), list.get(0), (list = Bytes.splitStr(null, string)).get(1).equals("LAUNCHED") || list.size() < 3 ? "" : list.get(2));
                continue;
            }
            if (string2.equals("STREAM")) {
                list = Bytes.splitStr(null, string);
                this.handler.streamStatus(list.get(1), list.get(0), list.get(3));
                continue;
            }
            if (string2.equals("ORCONN")) {
                list = Bytes.splitStr(null, string);
                this.handler.orConnStatus(list.get(1), list.get(0));
                continue;
            }
            if (string2.equals("BW")) {
                list = Bytes.splitStr(null, string);
                this.handler.bandwidthUsed(Integer.parseInt(list.get(0)), Integer.parseInt(list.get(1)));
                continue;
            }
            if (string2.equals("NEWDESC")) {
                list = Bytes.splitStr(null, string);
                this.handler.newDescriptors(list);
                continue;
            }
            if (string2.equals("DEBUG") || string2.equals("INFO") || string2.equals("NOTICE") || string2.equals("WARN") || string2.equals("ERR")) {
                this.handler.message(string2, string);
                continue;
            }
            this.handler.unrecognized(string2, string);
        }
    }

    public void setDebugging(PrintWriter printWriter) {
        this.debugOutput = printWriter;
    }

    public void setDebugging(PrintStream printStream) {
        this.debugOutput = new PrintWriter(printStream, true);
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.handler = eventHandler;
    }

    public synchronized Thread launchThread(boolean bl) {
        ControlParseThread controlParseThread = new ControlParseThread();
        if (bl) {
            controlParseThread.setDaemon(true);
        }
        controlParseThread.start();
        this.thread = controlParseThread;
        return controlParseThread;
    }

    protected synchronized void checkThread() {
        if (this.thread == null) {
            this.launchThread(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void react() throws IOException {
        while (true) {
            LinkedList<Waiter> linkedList;
            ArrayList<ReplyLine> arrayList;
            if ((arrayList = this.readReply()).isEmpty()) {
                linkedList = this.waiters;
                synchronized (linkedList) {
                    if (!this.waiters.isEmpty()) {
                        for (Waiter waiter : this.waiters) {
                            waiter.interrupt();
                        }
                    }
                }
                throw new TorNotRunningException();
            }
            if (arrayList.get((int)0).status.startsWith("6")) {
                this.handleEvent(arrayList);
                continue;
            }
            linkedList = this.waiters;
            synchronized (linkedList) {
                if (!this.waiters.isEmpty()) {
                    Waiter waiter = this.waiters.removeFirst();
                    waiter.setResponse(arrayList);
                }
            }
        }
    }

    public void setConf(String string, String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + " " + string2);
        this.setConf(arrayList);
    }

    public void setConf(Map<String, String> map) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(entry.getKey() + " " + entry.getValue() + "\n");
        }
        this.setConf(arrayList);
    }

    public void setConf(Collection<String> collection) throws IOException {
        if (collection.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("SETCONF");
        for (String string : collection) {
            int n = string.indexOf(32);
            if (n == -1) {
                stringBuilder.append(" ").append(string);
            }
            stringBuilder.append(" ").append(string, 0, n).append("=").append(TorControlConnection.quote(string.substring(n + 1)));
        }
        stringBuilder.append("\r\n");
        this.sendAndWaitForResponse(stringBuilder.toString(), null);
    }

    public void resetConf(Collection<String> collection) throws IOException {
        if (collection.size() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("RESETCONF");
        for (String string : collection) {
            stringBuilder.append(" ").append(string);
        }
        stringBuilder.append("\r\n");
        this.sendAndWaitForResponse(stringBuilder.toString(), null);
    }

    public List<ConfigEntry> getConf(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        return this.getConf(arrayList);
    }

    public List<ConfigEntry> getConf(Collection<String> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("GETCONF");
        for (String object2 : collection) {
            stringBuilder.append(" ").append(object2);
        }
        stringBuilder.append("\r\n");
        List<ReplyLine> list = this.sendAndWaitForResponse(stringBuilder.toString(), null);
        ArrayList<ConfigEntry> arrayList = new ArrayList<ConfigEntry>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ReplyLine replyLine = (ReplyLine)iterator.next();
            String string = replyLine.msg;
            int n = string.indexOf(61);
            if (n >= 0) {
                arrayList.add(new ConfigEntry(string.substring(0, n), string.substring(n + 1)));
                continue;
            }
            arrayList.add(new ConfigEntry(string));
        }
        return arrayList;
    }

    public void setEvents(List<String> list) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("SETEVENTS");
        for (String string : list) {
            stringBuilder.append(" ").append(string);
        }
        stringBuilder.append("\r\n");
        this.sendAndWaitForResponse(stringBuilder.toString(), null);
    }

    public void authenticate(byte[] byArray) throws IOException {
        String string = "AUTHENTICATE " + Bytes.hex(byArray) + "\r\n";
        this.sendAndWaitForResponse(string, null);
    }

    public void saveConf() throws IOException {
        this.sendAndWaitForResponse("SAVECONF\r\n", null);
    }

    public void signal(String string) throws IOException {
        String string2 = "SIGNAL " + string + "\r\n";
        this.sendAndWaitForResponse(string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTor(String string) throws IOException {
        String string2 = "SIGNAL " + string + "\r\n";
        if (this.debugOutput != null) {
            this.debugOutput.print(">> " + string2);
        }
        LinkedList<Waiter> linkedList = this.waiters;
        synchronized (linkedList) {
            this.output.write(string2);
            this.output.flush();
        }
    }

    public Map<String, String> mapAddresses(Collection<String> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("MAPADDRESS");
        for (String object2 : collection) {
            int iterator = object2.indexOf(32);
            stringBuilder.append(" ").append(object2, 0, iterator).append("=").append(TorControlConnection.quote(object2.substring(iterator + 1)));
        }
        stringBuilder.append("\r\n");
        List<ReplyLine> list = this.sendAndWaitForResponse(stringBuilder.toString(), null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ReplyLine replyLine = (ReplyLine)iterator.next();
            String string = replyLine.msg;
            int n = string.indexOf(61);
            hashMap.put(string.substring(0, n), string.substring(n + 1));
        }
        return hashMap;
    }

    public Map<String, String> mapAddresses(Map<String, String> map) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(entry.getKey() + " " + entry.getValue());
        }
        return this.mapAddresses(arrayList);
    }

    public String mapAddress(String string, String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + " " + string2 + "\n");
        Map<String, String> map = this.mapAddresses(arrayList);
        return map.get(string);
    }

    public Map<String, String> getInfo(Collection<String> collection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("GETINFO");
        for (String object2 : collection) {
            stringBuilder.append(" ").append(object2);
        }
        stringBuilder.append("\r\n");
        List<ReplyLine> list = this.sendAndWaitForResponse(stringBuilder.toString(), null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ReplyLine replyLine = (ReplyLine)iterator.next();
            int n = replyLine.msg.indexOf(61);
            if (n < 0) break;
            String string = replyLine.msg.substring(0, n);
            String string2 = replyLine.rest != null ? replyLine.rest : replyLine.msg.substring(n + 1);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public String getInfo(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        Map<String, String> map = this.getInfo(arrayList);
        return map.get(string);
    }

    public String extendCircuit(String string, String string2) throws IOException {
        List<ReplyLine> list = this.sendAndWaitForResponse("EXTENDCIRCUIT " + string + " " + string2 + "\r\n", null);
        return list.get((int)0).msg;
    }

    public void attachStream(String string, String string2) throws IOException {
        this.sendAndWaitForResponse("ATTACHSTREAM " + string + " " + string2 + "\r\n", null);
    }

    public String postDescriptor(String string) throws IOException {
        List<ReplyLine> list = this.sendAndWaitForResponse("+POSTDESCRIPTOR\r\n", string);
        return list.get((int)0).msg;
    }

    public void redirectStream(String string, String string2) throws IOException {
        this.sendAndWaitForResponse("REDIRECTSTREAM " + string + " " + string2 + "\r\n", null);
    }

    public void closeStream(String string, byte by) throws IOException {
        this.sendAndWaitForResponse("CLOSESTREAM " + string + " " + by + "\r\n", null);
    }

    public void closeCircuit(String string, boolean bl) throws IOException {
        this.sendAndWaitForResponse("CLOSECIRCUIT " + string + (bl ? " IFUNUSED" : "") + "\r\n", null);
    }

    public void takeOwnership() throws IOException {
        this.sendAndWaitForResponse("TAKEOWNERSHIP\r\n", null);
    }

    public Map<String, String> addOnion(Map<Integer, String> map) throws IOException {
        return this.addOnion("NEW:BEST", map, null);
    }

    public Map<String, String> addOnion(Map<Integer, String> map, boolean bl, boolean bl2) throws IOException {
        return this.addOnion("NEW:BEST", map, bl, bl2);
    }

    public Map<String, String> addOnion(String string, Map<Integer, String> map) throws IOException {
        return this.addOnion(string, map, null);
    }

    public Map<String, String> addOnion(String string, Map<Integer, String> map, boolean bl, boolean bl2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            arrayList.add("DiscardPK");
        }
        if (bl2) {
            arrayList.add("Detach");
        }
        return this.addOnion(string, map, arrayList);
    }

    public Map<String, String> addOnion(String string, Map<Integer, String> map, List<String> list) throws IOException {
        Object object;
        if (string.indexOf(58) < 0) {
            throw new IllegalArgumentException("Invalid privKey");
        }
        if (map == null || map.size() < 1) {
            throw new IllegalArgumentException("Must provide at least one port line");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ADD_ONION ").append(string);
        if (list != null && list.size() > 0) {
            stringBuilder.append(" Flags=");
            object = "";
            for (String string2 : list) {
                stringBuilder.append((String)object).append(string2);
                object = ",";
            }
        }
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            int n = entry.getKey();
            String string3 = entry.getValue();
            stringBuilder.append(" Port=").append(n);
            if (string3 == null || string3.length() <= 0) continue;
            stringBuilder.append(",").append(string3);
        }
        stringBuilder.append("\r\n");
        object = this.sendAndWaitForResponse(stringBuilder.toString(), null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("onionAddress", object.get((int)0).msg.split("=", 2)[1]);
        if (object.size() > 2) {
            hashMap.put("onionPrivKey", ((ReplyLine)object.get((int)1)).msg.split("=", 2)[1]);
        }
        return hashMap;
    }

    public void delOnion(String string) throws IOException {
        this.sendAndWaitForResponse("DEL_ONION " + string + "\r\n", null);
    }

    static class ReplyLine {
        final String status;
        final String msg;
        final String rest;

        ReplyLine(String string, String string2, String string3) {
            this.status = string;
            this.msg = string2;
            this.rest = string3;
        }
    }

    static class Waiter {
        List<ReplyLine> response;
        boolean interrupted;

        Waiter() {
        }

        synchronized List<ReplyLine> getResponse() throws InterruptedException {
            while (this.response == null) {
                this.wait();
                if (!this.interrupted) continue;
                throw new InterruptedException();
            }
            return this.response;
        }

        synchronized void setResponse(List<ReplyLine> list) {
            this.response = list;
            this.notifyAll();
        }

        synchronized void interrupt() {
            this.interrupted = true;
            this.notifyAll();
        }
    }

    protected class ControlParseThread
    extends Thread {
        protected ControlParseThread() {
        }

        @Override
        public void run() {
            try {
                TorControlConnection.this.react();
            }
            catch (IOException iOException) {
                TorControlConnection.this.parseThreadException = iOException;
            }
        }
    }
}

