/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.freehaven.tor.control.Bytes;

public class PasswordDigest {
    private final byte[] secret;
    private final String hashedKey;
    private static final int EXPBIAS = 6;

    public static PasswordDigest generateDigest() {
        byte[] byArray = new byte[20];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        return new PasswordDigest(byArray);
    }

    public PasswordDigest(byte[] byArray) {
        this(byArray, null);
    }

    public PasswordDigest(byte[] byArray, byte[] byArray2) {
        this.secret = (byte[])byArray.clone();
        if (byArray2 == null) {
            byArray2 = new byte[9];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray2);
            byArray2[8] = 96;
        }
        this.hashedKey = "16:" + PasswordDigest.encodeBytes(PasswordDigest.secretToKey(byArray, byArray2));
    }

    public byte[] getSecret() {
        return (byte[])this.secret.clone();
    }

    public String getHashedPassword() {
        return this.hashedKey;
    }

    public static byte[] secretToKey(byte[] byArray, byte[] byArray2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Can't run without sha-1.");
        }
        int n = byArray2[8] & 0xFF;
        int n2 = 16 + (n & 0xF) << (n >> 4) + 6;
        byte[] byArray3 = new byte[8 + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, 8);
        System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
        while (n2 > 0) {
            if (n2 >= byArray3.length) {
                messageDigest.update(byArray3);
                n2 -= byArray3.length;
                continue;
            }
            messageDigest.update(byArray3, 0, n2);
            n2 = 0;
        }
        byte[] byArray4 = new byte[29];
        System.arraycopy(messageDigest.digest(), 0, byArray4, 9, 20);
        System.arraycopy(byArray2, 0, byArray4, 0, 9);
        return byArray4;
    }

    private static String encodeBytes(byte[] byArray) {
        return Bytes.hex(byArray);
    }
}

