// Code generated by smithy-go-codegen DO NOT EDIT.

package sqs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous task to move messages from a specified source queue to a
// specified destination queue.
//   - This action is currently limited to supporting message redrive from queues
//     that are configured as dead-letter queues (DLQs) (https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html)
//     of other Amazon SQS queues only. Non-SQS queue sources of dead-letter queues,
//     such as Lambda or Amazon SNS topics, are currently not supported.
//   - In dead-letter queues redrive context, the StartMessageMoveTask the source
//     queue is the DLQ, while the destination queue can be the original source queue
//     (from which the messages were driven to the dead-letter-queue), or a custom
//     destination queue.
//   - Currently, only standard queues support redrive. FIFO queues don't support
//     redrive.
//   - Only one active message movement task is supported per queue at any given
//     time.
func (c *Client) StartMessageMoveTask(ctx context.Context, params *StartMessageMoveTaskInput, optFns ...func(*Options)) (*StartMessageMoveTaskOutput, error) {
	if params == nil {
		params = &StartMessageMoveTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartMessageMoveTask", params, optFns, c.addOperationStartMessageMoveTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartMessageMoveTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartMessageMoveTaskInput struct {

	// The ARN of the queue that contains the messages to be moved to another queue.
	// Currently, only ARNs of dead-letter queues (DLQs) whose sources are other Amazon
	// SQS queues are accepted. DLQs whose sources are non-SQS queues, such as Lambda
	// or Amazon SNS topics, are not currently supported.
	//
	// This member is required.
	SourceArn *string

	// The ARN of the queue that receives the moved messages. You can use this field
	// to specify the destination queue where you would like to redrive messages. If
	// this field is left blank, the messages will be redriven back to their respective
	// original source queues.
	DestinationArn *string

	// The number of messages to be moved per second (the message movement rate). You
	// can use this field to define a fixed message movement rate. The maximum value
	// for messages per second is 500. If this field is left blank, the system will
	// optimize the rate based on the queue message backlog size, which may vary
	// throughout the duration of the message movement task.
	MaxNumberOfMessagesPerSecond *int32

	noSmithyDocumentSerde
}

type StartMessageMoveTaskOutput struct {

	// An identifier associated with a message movement task. You can use this
	// identifier to cancel a specified message movement task using the
	// CancelMessageMoveTask action.
	TaskHandle *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartMessageMoveTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpStartMessageMoveTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpStartMessageMoveTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartMessageMoveTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartMessageMoveTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartMessageMoveTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartMessageMoveTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartMessageMoveTask",
	}
}
