/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.moat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Dns;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.briarproject.moat.Bridges;
import org.briarproject.moat.NoDns;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.socks.SocksSocketFactory;

@NotNullByDefault
public class MoatApi {
    private static final String MOAT_URL = "https://bridges.torproject.org/moat";
    private static final String MOAT_CIRCUMVENTION_SETTINGS = "circumvention/settings";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String PORT_PREFIX = "CMETHOD meek_lite socks5 127.0.0.1:";
    private static final int CONNECT_TO_PROXY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final int EXTRA_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(120L);
    private static final int EXTRA_SOCKET_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final String SOCKS_PASSWORD = "\u0000";
    private final File obfs4Executable;
    private final File obfs4Dir;
    private final String url;
    private final String front;
    private final JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).build();

    public MoatApi(File obfs4Executable, File obfs4Dir, String url, String front) {
        if (!obfs4Dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.obfs4Executable = obfs4Executable;
        this.obfs4Dir = obfs4Dir;
        this.url = url;
        this.front = front;
    }

    public List<Bridges> get() throws IOException {
        return this.getWithCountry("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Bridges> getWithCountry(String country) throws IOException {
        Process obfs4Process = this.startObfs4();
        try {
            int port = this.getPort(obfs4Process);
            String socksUsername = "url=" + this.url + ";front=" + this.front;
            SocksSocketFactory socketFactory = new SocksSocketFactory((SocketAddress)new InetSocketAddress("localhost", port), CONNECT_TO_PROXY_TIMEOUT, EXTRA_CONNECT_TIMEOUT, EXTRA_SOCKET_TIMEOUT, socksUsername, SOCKS_PASSWORD);
            OkHttpClient client = new OkHttpClient.Builder().socketFactory((SocketFactory)socketFactory).dns((Dns)new NoDns()).build();
            String requestJson = country.isEmpty() ? "" : "{\"country\": \"" + country + "\"}";
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)requestJson);
            Request request = new Request.Builder().url("https://bridges.torproject.org/moat/circumvention/settings").post(requestBody).build();
            Response response = client.newCall(request).execute();
            ResponseBody responseBody = response.body();
            if (!response.isSuccessful() || responseBody == null) {
                throw new IOException("request error");
            }
            String responseJson = responseBody.string();
            List<Bridges> list = this.parseResponse(responseJson);
            return list;
        }
        finally {
            obfs4Process.destroy();
        }
    }

    private List<Bridges> parseResponse(String responseJson) throws IOException {
        JsonNode node = this.mapper.readTree(responseJson);
        JsonNode settings = node.get("settings");
        if (settings == null) {
            throw new IOException("no settings in response");
        }
        if (!settings.isArray()) {
            throw new IOException("settings not an array");
        }
        ArrayList<Bridges> bridges = new ArrayList<Bridges>();
        for (JsonNode n : settings) {
            bridges.add(this.parseBridges(n));
        }
        return bridges;
    }

    private Bridges parseBridges(JsonNode node) throws IOException {
        List<String> bridges;
        JsonNode bridgesNode = node.get("bridges");
        if (bridgesNode == null) {
            throw new IOException("no bridges node");
        }
        String type = bridgesNode.get("type").asText();
        String source = bridgesNode.get("source").asText();
        JsonNode bridgeStrings = bridgesNode.get("bridge_strings");
        if (bridgeStrings instanceof ArrayNode) {
            bridges = new ArrayList();
            for (JsonNode b : bridgeStrings) {
                bridges.add(b.asText());
            }
        } else {
            bridges = Collections.emptyList();
        }
        return new Bridges(type, source, bridges);
    }

    private Process startObfs4() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(this.obfs4Executable.getAbsolutePath());
        Map<String, String> env = pb.environment();
        env.put("TOR_PT_MANAGED_TRANSPORT_VER", "1");
        env.put("TOR_PT_STATE_LOCATION", this.obfs4Dir.getAbsolutePath());
        env.put("TOR_PT_EXIT_ON_STDIN_CLOSE", "1");
        env.put("TOR_PT_CLIENT_TRANSPORTS", "meek_lite");
        pb.redirectErrorStream(true);
        try {
            return pb.start();
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
    }

    private int getPort(Process process) throws IOException {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Thread t = new Thread(() -> this.getPort(process, queue));
        t.setDaemon(false);
        t.start();
        try {
            int port = (Integer)queue.take();
            if (port == -1) {
                throw new IOException("Failed to parse port number from stdout");
            }
            return port;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void getPort(Process process, BlockingQueue<Integer> queue) {
        boolean found;
        block12: {
            found = false;
            Scanner s = new Scanner(process.getInputStream());
            block9: while (true) {
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    if (found || !line.startsWith(PORT_PREFIX)) continue;
                    found = true;
                    try {
                        queue.add(Integer.parseInt(line.substring(PORT_PREFIX.length())));
                        continue block9;
                    }
                    catch (NumberFormatException e) {
                        queue.add(-1);
                    }
                }
                break block12;
                {
                    continue block9;
                    break;
                }
                break;
            }
            finally {
                s.close();
            }
        }
        if (!found) {
            queue.add(-1);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

