/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.moat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Dns;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.briarproject.moat.Bridges;
import org.briarproject.moat.NoDns;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;
import org.briarproject.socks.SocksSocketFactory;

@NotNullByDefault
public class MoatApi {
    private static final Logger LOG = Logger.getLogger(MoatApi.class.getName());
    private static final String MOAT_URL = "https://bridges.torproject.org/moat";
    private static final String MOAT_CIRCUMVENTION_SETTINGS = "circumvention/settings";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String PORT_PREFIX = "CMETHOD meek_lite socks5 127.0.0.1:";
    private static final String ISRG_RESOURCE_NAME = "isrg-root-x1.der";
    private static final int CONNECT_TO_PROXY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final int EXTRA_CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(120L);
    private static final int EXTRA_SOCKET_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final String SOCKS_PASSWORD = "\u0000";
    private final File lyrebirdExecutable;
    private final File lyrebirdDir;
    private final String url;
    private final String front;
    private final boolean addIsrgRootCertificate;
    private final JsonMapper mapper = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES})).build();

    public MoatApi(File lyrebirdExecutable, File lyrebirdDir, String url, String front) {
        this(lyrebirdExecutable, lyrebirdDir, url, front, false);
    }

    public MoatApi(File lyrebirdExecutable, File lyrebirdDir, String url, String front, boolean addIsrgRootCertificate) {
        if (!lyrebirdDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.lyrebirdExecutable = lyrebirdExecutable;
        this.lyrebirdDir = lyrebirdDir;
        this.url = url;
        this.front = front;
        this.addIsrgRootCertificate = addIsrgRootCertificate;
    }

    public List<Bridges> get() throws IOException {
        return this.getWithCountry("");
    }

    public List<Bridges> getWithCountry(String country) throws IOException {
        Process lyrebirdProcess = this.startLyrebird();
        try {
            int port = this.getPort(lyrebirdProcess);
            String socksUsername = "url=" + this.url + ";front=" + this.front;
            SocksSocketFactory socketFactory = new SocksSocketFactory((SocketAddress)new InetSocketAddress("localhost", port), CONNECT_TO_PROXY_TIMEOUT, EXTRA_CONNECT_TIMEOUT, EXTRA_SOCKET_TIMEOUT, socksUsername, SOCKS_PASSWORD);
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().socketFactory((SocketFactory)socketFactory).dns((Dns)new NoDns());
            if (this.addIsrgRootCertificate) {
                X509TrustManager trustManager = this.createTrustManager();
                clientBuilder.sslSocketFactory(this.createSslSocketFactory(trustManager), trustManager);
            }
            OkHttpClient client = clientBuilder.build();
            String requestJson = country.isEmpty() ? "" : "{\"country\": \"" + country + "\"}";
            RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)requestJson);
            Request request = new Request.Builder().url("https://bridges.torproject.org/moat/circumvention/settings").post(requestBody).build();
            Response response = client.newCall(request).execute();
            ResponseBody responseBody = response.body();
            if (!response.isSuccessful() || responseBody == null) {
                throw new IOException("request error");
            }
            String responseJson = responseBody.string();
            List<Bridges> list = this.parseResponse(responseJson);
            return list;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
        finally {
            lyrebirdProcess.destroy();
        }
    }

    private List<Bridges> parseResponse(String responseJson) throws IOException {
        JsonNode node = this.mapper.readTree(responseJson);
        JsonNode settings = node.get("settings");
        if (settings == null) {
            throw new IOException("no settings in response");
        }
        if (!settings.isArray()) {
            throw new IOException("settings not an array");
        }
        ArrayList<Bridges> bridges = new ArrayList<Bridges>();
        for (JsonNode n : settings) {
            bridges.add(this.parseBridges(n));
        }
        return bridges;
    }

    private Bridges parseBridges(JsonNode node) throws IOException {
        List<String> bridges;
        JsonNode bridgesNode = node.get("bridges");
        if (bridgesNode == null) {
            throw new IOException("no bridges node");
        }
        String type = bridgesNode.get("type").asText();
        String source = bridgesNode.get("source").asText();
        JsonNode bridgeStrings = bridgesNode.get("bridge_strings");
        if (bridgeStrings instanceof ArrayNode) {
            bridges = new ArrayList();
            for (JsonNode b : bridgeStrings) {
                bridges.add(b.asText());
            }
        } else {
            bridges = Collections.emptyList();
        }
        return new Bridges(type, source, bridges);
    }

    private Process startLyrebird() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(this.lyrebirdExecutable.getAbsolutePath());
        Map<String, String> env = pb.environment();
        env.put("TOR_PT_MANAGED_TRANSPORT_VER", "1");
        env.put("TOR_PT_STATE_LOCATION", this.lyrebirdDir.getAbsolutePath());
        env.put("TOR_PT_EXIT_ON_STDIN_CLOSE", "1");
        env.put("TOR_PT_CLIENT_TRANSPORTS", "meek_lite");
        pb.redirectErrorStream(true);
        try {
            return pb.start();
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
    }

    private int getPort(Process process) throws IOException {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Thread t = new Thread(() -> this.getPort(process, queue));
        t.setDaemon(false);
        t.start();
        try {
            int port = (Integer)queue.take();
            if (port == -1) {
                throw new IOException("Failed to parse port number from stdout");
            }
            return port;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void getPort(Process process, BlockingQueue<Integer> queue) {
        boolean found;
        block12: {
            found = false;
            Scanner s = new Scanner(process.getInputStream());
            block9: while (true) {
                while (s.hasNextLine()) {
                    String line = s.nextLine();
                    if (found || !line.startsWith(PORT_PREFIX)) continue;
                    found = true;
                    try {
                        queue.add(Integer.parseInt(line.substring(PORT_PREFIX.length())));
                        continue block9;
                    }
                    catch (NumberFormatException e) {
                        queue.add(-1);
                    }
                }
                break block12;
                {
                    continue block9;
                    break;
                }
                break;
            }
            finally {
                s.close();
            }
        }
        if (!found) {
            queue.add(-1);
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private SSLSocketFactory createSslSocketFactory(X509TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{trustManager}, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private X509TrustManager createTrustManager() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        X509TrustManager x509 = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            x509 = (X509TrustManager)tm;
            break;
        }
        if (x509 == null) {
            throw new IOException("Could not find default X-509 trust manager");
        }
        final X509TrustManager delegate = x509;
        final X509Certificate authority = this.createX509Certificate();
        return new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                delegate.checkClientTrusted(chain, authType);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                LOG.info("Auth type: " + authType);
                try {
                    delegate.checkServerTrusted(chain, authType);
                    LOG.info("Certificate chain was verified by default trust manager");
                }
                catch (CertificateException e) {
                    LOG.info("Certificate chain was not verified by default trust manager: " + e);
                    MoatApi.validateCertificateChain(chain, authority);
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                X509Certificate[] defaultIssuers = delegate.getAcceptedIssuers();
                X509Certificate[] allIssuers = new X509Certificate[defaultIssuers.length + 1];
                System.arraycopy(defaultIssuers, 0, allIssuers, 0, defaultIssuers.length);
                allIssuers[defaultIssuers.length] = authority;
                return allIssuers;
            }
        };
    }

    private X509Certificate createX509Certificate() throws CertificateException {
        InputStream in = (InputStream)NullSafety.requireNonNull((Object)this.getClass().getClassLoader().getResourceAsStream(ISRG_RESOURCE_NAME));
        CertificateFactory certFactory = CertificateFactory.getInstance("X509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in);
        LOG.info("Adding certificate authority, issuer: " + cert.getIssuerX500Principal().getName() + ", subject: " + cert.getSubjectX500Principal().getName());
        return cert;
    }

    static void validateCertificateChain(X509Certificate[] chain, X509Certificate authority) throws CertificateException {
        if (chain.length == 0) {
            throw new CertificateException("Certificate chain is empty");
        }
        X509Certificate prev = authority;
        for (int i = chain.length - 1; i >= 0; --i) {
            X509Certificate curr = chain[i];
            LOG.info("Checking subject: " + curr.getSubjectX500Principal().getName());
            curr.checkValidity();
            if (!Arrays.equals(curr.getIssuerUniqueID(), prev.getSubjectUniqueID())) {
                throw new CertificateException("Certificate issuer unique ID does not match");
            }
            if (!curr.getIssuerX500Principal().getName().equals(prev.getSubjectX500Principal().getName())) {
                throw new CertificateException("Certificate issuer name does not match");
            }
            boolean[] keyUsage = curr.getKeyUsage();
            if (keyUsage.length == 0 || !keyUsage[0]) {
                throw new CertificateException("Certificate is not authorised for digital signatures");
            }
            if (!(i <= 0 || keyUsage.length >= 6 && keyUsage[5])) {
                throw new CertificateException("Certificate is not authorised for signing certificates");
            }
            int constraints = curr.getBasicConstraints();
            int caPathLength = i - 1;
            if (constraints == -1) {
                LOG.info("Non-CA certificate");
                if (i != 0) {
                    throw new CertificateException("Non-CA certificate found at invalid position");
                }
            } else {
                if (i == 0) {
                    throw new CertificateException("CA certificate found at invalid position");
                }
                LOG.info("CA certificate with maximum CA path length: " + constraints);
                if (constraints < caPathLength) {
                    throw new CertificateException("CA certificate has maximum CA path length: " + constraints + ", needed: " + caPathLength);
                }
            }
            try {
                curr.verify(prev.getPublicKey());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e1) {
                throw new CertificateException(e1);
            }
            prev = curr;
        }
        LOG.info("Certificate chain accepted");
    }
}

