/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlConnection;
import org.briarproject.nullsafety.InterfaceNotNullByDefault;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;
import org.briarproject.onionwrapper.TorUtils;
import org.briarproject.onionwrapper.TorWrapper;

@InterfaceNotNullByDefault
abstract class AbstractTorWrapper
implements EventHandler,
TorWrapper {
    private static final String[] EVENTS = new String[]{"CIRC", "ORCONN", "STATUS_GENERAL", "STATUS_CLIENT", "HS_DESC", "NOTICE", "WARN", "ERR"};
    private static final String OWNER = "__OwningControllerProcess";
    private static final int COOKIE_TIMEOUT_MS = 3000;
    private static final int COOKIE_POLLING_INTERVAL_MS = 200;
    private static final Pattern BOOTSTRAP_PERCENTAGE = Pattern.compile(".*PROGRESS=(\\d{1,3}).*");
    protected final Executor ioExecutor;
    protected final Executor eventExecutor;
    private final String architecture;
    private final File torDirectory;
    private final File configFile;
    private final File doneFile;
    private final File cookieFile;
    private final int torSocksPort;
    private final int torControlPort;
    private final AtomicBoolean used = new AtomicBoolean(false);
    protected final NetworkState state = new NetworkState();
    private volatile Socket controlSocket = null;
    private volatile TorControlConnection controlConnection = null;

    protected abstract int getProcessId();

    protected abstract long getLastUpdateTime();

    protected abstract InputStream getResourceInputStream(String var1, String var2);

    AbstractTorWrapper(Executor ioExecutor, Executor eventExecutor, String architecture, File torDirectory, int torSocksPort, int torControlPort) {
        this.ioExecutor = ioExecutor;
        this.eventExecutor = eventExecutor;
        this.architecture = architecture;
        this.torDirectory = torDirectory;
        this.torSocksPort = torSocksPort;
        this.torControlPort = torControlPort;
        this.configFile = new File(torDirectory, "torrc");
        this.doneFile = new File(torDirectory, "done");
        this.cookieFile = new File(torDirectory, ".tor/control_auth_cookie");
    }

    protected File getTorExecutableFile() {
        return new File(this.torDirectory, "tor");
    }

    protected File getObfs4ExecutableFile() {
        return new File(this.torDirectory, "obfs4proxy");
    }

    protected File getSnowflakeExecutableFile() {
        return new File(this.torDirectory, "snowflake");
    }

    @Override
    public void setObserver(@Nullable TorWrapper.Observer observer) {
        this.state.setObserver(observer);
    }

    @Override
    public void start() throws IOException, InterruptedException {
        Process torProcess;
        if (this.used.getAndSet(true)) {
            throw new IllegalStateException();
        }
        if (!this.torDirectory.exists() && !this.torDirectory.mkdirs()) {
            throw new IOException("Could not create Tor directory");
        }
        if (!this.assetsAreUpToDate()) {
            this.installAssets();
        }
        this.extract(this.getConfigInputStream(), this.configFile);
        if (this.cookieFile.exists() && !this.cookieFile.delete()) {
            LOG.warning("Old auth cookie not deleted");
        }
        LOG.info("Starting Tor");
        File torFile = this.getTorExecutableFile();
        String torPath = torFile.getAbsolutePath();
        String configPath = this.configFile.getAbsolutePath();
        String pid = String.valueOf(this.getProcessId());
        ProcessBuilder pb = new ProcessBuilder(torPath, "-f", configPath, OWNER, pid);
        Map<String, String> env = pb.environment();
        env.put("HOME", this.torDirectory.getAbsolutePath());
        pb.directory(this.torDirectory);
        pb.redirectErrorStream(true);
        try {
            torProcess = pb.start();
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        this.waitForTorToStart(torProcess);
        long start = System.currentTimeMillis();
        while (this.cookieFile.length() < 32L) {
            if (System.currentTimeMillis() - start > 3000L) {
                throw new IOException("Auth cookie not created");
            }
            Thread.sleep(200L);
        }
        LOG.info("Auth cookie created");
        this.controlSocket = new Socket("127.0.0.1", this.torControlPort);
        this.controlConnection = new TorControlConnection(this.controlSocket);
        this.controlConnection.authenticate(this.read(this.cookieFile));
        this.controlConnection.takeOwnership();
        this.controlConnection.resetConf(Collections.singletonList(OWNER));
        this.controlConnection.setEventHandler((EventHandler)this);
        this.controlConnection.setEvents(Arrays.asList(EVENTS));
        String info = this.controlConnection.getInfo("status/bootstrap-phase");
        if (info != null && info.contains("PROGRESS=")) {
            int percentage = this.parseBootstrapPercentage(info);
            if (percentage == 100) {
                LOG.info("Tor has already bootstrapped");
            }
            this.state.setBootstrapPercentage(percentage);
        }
        if ("1".equals(info = this.controlConnection.getInfo("status/circuit-established"))) {
            LOG.info("Tor has already built a circuit");
            this.state.setCircuitBuilt(true);
        }
        this.state.setStarted();
    }

    private boolean assetsAreUpToDate() {
        return this.doneFile.lastModified() > this.getLastUpdateTime();
    }

    private void installAssets() throws IOException {
        this.doneFile.delete();
        this.installTorExecutable();
        this.installObfs4Executable();
        this.installSnowflakeExecutable();
        this.extract(this.getConfigInputStream(), this.configFile);
        if (!this.doneFile.createNewFile()) {
            LOG.warning("Failed to create done file");
        }
    }

    protected void extract(InputStream in, File dest) throws IOException {
        FileOutputStream out = new FileOutputStream(dest);
        TorUtils.copyAndClose(in, out);
    }

    protected void installTorExecutable() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Installing Tor binary for " + this.architecture);
        }
        File torFile = this.getTorExecutableFile();
        this.extract(this.getExecutableInputStream("tor"), torFile);
        if (!torFile.setExecutable(true, true)) {
            throw new IOException();
        }
    }

    protected void installObfs4Executable() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Installing obfs4proxy binary for " + this.architecture);
        }
        File obfs4File = this.getObfs4ExecutableFile();
        this.extract(this.getExecutableInputStream("obfs4proxy"), obfs4File);
        if (!obfs4File.setExecutable(true, true)) {
            throw new IOException();
        }
    }

    protected void installSnowflakeExecutable() throws IOException {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Installing snowflake binary for " + this.architecture);
        }
        File snowflakeFile = this.getSnowflakeExecutableFile();
        this.extract(this.getExecutableInputStream("snowflake"), snowflakeFile);
        if (!snowflakeFile.setExecutable(true, true)) {
            throw new IOException();
        }
    }

    private InputStream getExecutableInputStream(String basename) {
        String ext = this.getExecutableExtension();
        return (InputStream)NullSafety.requireNonNull((Object)this.getResourceInputStream(this.architecture + "/" + basename, ext));
    }

    protected String getExecutableExtension() {
        return "";
    }

    private static void append(StringBuilder strb, String name, Object value) {
        strb.append(name);
        strb.append(" ");
        strb.append(value);
        strb.append("\n");
    }

    private InputStream getConfigInputStream() {
        File dataDirectory = new File(this.torDirectory, ".tor");
        StringBuilder strb = new StringBuilder();
        AbstractTorWrapper.append(strb, "ControlPort", this.torControlPort);
        AbstractTorWrapper.append(strb, "CookieAuthentication", 1);
        AbstractTorWrapper.append(strb, "DataDirectory", dataDirectory.getAbsolutePath());
        AbstractTorWrapper.append(strb, "DisableNetwork", 1);
        AbstractTorWrapper.append(strb, "RunAsDaemon", 1);
        AbstractTorWrapper.append(strb, "SafeSocks", 1);
        AbstractTorWrapper.append(strb, "SocksPort", this.torSocksPort);
        strb.append("GeoIPFile\n");
        strb.append("GeoIPv6File\n");
        AbstractTorWrapper.append(strb, "ConnectionPadding", 0);
        String obfs4Path = this.getObfs4ExecutableFile().getAbsolutePath();
        AbstractTorWrapper.append(strb, "ClientTransportPlugin obfs4 exec", obfs4Path);
        AbstractTorWrapper.append(strb, "ClientTransportPlugin meek_lite exec", obfs4Path);
        String snowflakePath = this.getSnowflakeExecutableFile().getAbsolutePath();
        AbstractTorWrapper.append(strb, "ClientTransportPlugin snowflake exec", snowflakePath);
        return new ByteArrayInputStream(strb.toString().getBytes(TorUtils.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(File f) throws IOException {
        byte[] b = new byte[(int)f.length()];
        FileInputStream in = new FileInputStream(f);
        try {
            int read;
            for (int offset = 0; offset < b.length; offset += read) {
                read = in.read(b, offset, b.length - offset);
                if (read != -1) continue;
                throw new EOFException();
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            TorUtils.tryToClose(in, LOG, Level.WARNING);
        }
    }

    protected void waitForTorToStart(Process torProcess) throws InterruptedException, IOException {
        Scanner stdout = new Scanner(torProcess.getInputStream());
        if (stdout.hasNextLine()) {
            LOG.info(stdout.nextLine());
        }
        while (stdout.hasNextLine()) {
            stdout.nextLine();
        }
        stdout.close();
        int exit = torProcess.waitFor();
        if (exit != 0) {
            throw new IOException("Tor exited with value " + exit);
        }
    }

    @Override
    public TorWrapper.HiddenServiceProperties publishHiddenService(int localPort, int remotePort, @Nullable String privKey) throws IOException {
        Map<Integer, String> portLines = Collections.singletonMap(remotePort, "127.0.0.1:" + localPort);
        Map response = privKey == null ? this.getControlConnection().addOnion("NEW:ED25519-V3", portLines, null) : this.getControlConnection().addOnion(privKey, portLines);
        if (!response.containsKey("onionAddress")) {
            throw new IOException("Missing hidden service address");
        }
        if (privKey == null && !response.containsKey("onionPrivKey")) {
            throw new IOException("Missing private key");
        }
        String onion = (String)response.get("onionAddress");
        if (privKey == null) {
            privKey = (String)response.get("onionPrivKey");
        }
        return new TorWrapper.HiddenServiceProperties(onion, privKey);
    }

    @Override
    public void removeHiddenService(String onion) throws IOException {
        this.getControlConnection().delOnion(onion);
    }

    @Override
    public void enableNetwork(boolean enable) throws IOException {
        if (!this.state.enableNetwork(enable)) {
            return;
        }
        this.getControlConnection().setConf("DisableNetwork", enable ? "0" : "1");
    }

    @Override
    public void enableBridges(List<String> bridges) throws IOException {
        if (!this.state.setBridges(bridges)) {
            return;
        }
        ArrayList<String> conf = new ArrayList<String>(bridges.size() + 1);
        conf.add("UseBridges 1");
        conf.addAll(bridges);
        this.getControlConnection().setConf(conf);
    }

    @Override
    public void disableBridges() throws IOException {
        if (!this.state.setBridges(Collections.emptyList())) {
            return;
        }
        this.getControlConnection().setConf("UseBridges", "0");
    }

    @Override
    public void stop() throws IOException {
        this.state.setStopped();
        if (this.controlSocket != null && this.controlConnection != null) {
            LOG.info("Stopping Tor");
            try {
                this.controlConnection.shutdownTor("TERM");
            }
            finally {
                TorUtils.tryToClose(this.controlSocket, LOG, Level.WARNING);
            }
        }
    }

    public void circuitStatus(String status, String id, String path) {
        if (status.equals("BUILT") && this.state.setCircuitBuilt(true)) {
            LOG.info("Circuit built");
        }
    }

    public void streamStatus(String status, String id, String target) {
    }

    public void orConnStatus(String status, String orName) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("OR connection " + status);
        }
        if (status.equals("CONNECTED")) {
            this.state.onOrConnectionConnected();
        } else if (status.equals("CLOSED")) {
            this.state.onOrConnectionClosed();
        }
    }

    public void bandwidthUsed(long read, long written) {
    }

    public void newDescriptors(List<String> orList) {
    }

    public void message(String severity, String msg) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info(severity + " " + msg);
        }
    }

    public void unrecognized(String type, String msg) {
        if (type.equals("STATUS_CLIENT")) {
            this.handleClientStatus(this.removeSeverity(msg));
        } else if (type.equals("STATUS_GENERAL")) {
            this.handleGeneralStatus(this.removeSeverity(msg));
        } else if (type.equals("HS_DESC") && msg.startsWith("UPLOADED")) {
            String[] parts = msg.split(" ");
            if (parts.length < 2) {
                LOG.warning("Failed to parse HS_DESC UPLOADED event");
            } else if (LOG.isLoggable(Level.INFO)) {
                String onion = parts[1];
                LOG.info("V3 descriptor uploaded for " + TorUtils.scrubOnion(onion));
                this.state.onHsDescriptorUploaded(onion);
            }
        }
    }

    private String removeSeverity(String msg) {
        return msg.replaceFirst("[^ ]+ ", "");
    }

    private void handleClientStatus(String msg) {
        if (msg.startsWith("BOOTSTRAP PROGRESS=")) {
            int percentage = this.parseBootstrapPercentage(msg);
            if (percentage == 100) {
                LOG.info("Bootstrapped");
            }
            this.state.setBootstrapPercentage(percentage);
        } else if (msg.startsWith("CIRCUIT_ESTABLISHED")) {
            if (this.state.setCircuitBuilt(true)) {
                LOG.info("Circuit built");
            }
        } else if (msg.startsWith("CIRCUIT_NOT_ESTABLISHED") && this.state.setCircuitBuilt(false)) {
            LOG.info("Circuit not built");
        }
    }

    private int parseBootstrapPercentage(String s) {
        Matcher matcher = BOOTSTRAP_PERCENTAGE.matcher(s);
        if (matcher.matches()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Failed to parse bootstrap percentage: " + s);
        }
        return 0;
    }

    private void handleGeneralStatus(String msg) {
        Long skew;
        if (msg.startsWith("CLOCK_JUMPED")) {
            Long time = this.parseLongArgument(msg, "TIME");
            if (time != null && LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Clock jumped " + time + " seconds");
            }
        } else if (msg.startsWith("CLOCK_SKEW") && (skew = this.parseLongArgument(msg, "SKEW")) != null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Clock is skewed by " + skew + " seconds");
            }
            this.state.onClockSkewDetected(skew);
        }
    }

    @Nullable
    private Long parseLongArgument(String msg, String argName) {
        String[] args;
        for (String arg : args = msg.split(" ")) {
            if (!arg.startsWith(argName + "=")) continue;
            try {
                return Long.parseLong(arg.substring(argName.length() + 1));
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("Failed to parse " + argName + " from '" + msg + "'");
        }
        return null;
    }

    public void controlConnectionClosed() {
        if (this.state.isTorRunning()) {
            LOG.warning("Control connection closed");
        }
    }

    @Override
    public void enableConnectionPadding(boolean enable) throws IOException {
        if (!this.state.enableConnectionPadding(enable)) {
            return;
        }
        this.getControlConnection().setConf("ConnectionPadding", enable ? "1" : "0");
    }

    @Override
    public void enableIpv6(boolean enable) throws IOException {
        if (!this.state.enableIpv6(enable)) {
            return;
        }
        this.getControlConnection().setConf("ClientUseIPv4", enable ? "0" : "1");
        this.getControlConnection().setConf("ClientUseIPv6", enable ? "1" : "0");
    }

    @Override
    public TorWrapper.TorState getTorState() {
        return this.state.getState();
    }

    @Override
    public boolean isTorRunning() {
        return this.state.isTorRunning();
    }

    private TorControlConnection getControlConnection() throws IOException {
        TorControlConnection controlConnection = this.controlConnection;
        if (controlConnection == null) {
            throw new IOException("Control connection not opened");
        }
        return controlConnection;
    }

    @NotNullByDefault
    @ThreadSafe
    private class NetworkState {
        @Nullable
        @GuardedBy(value="this")
        private TorWrapper.Observer observer = null;
        @GuardedBy(value="this")
        private boolean started = false;
        @GuardedBy(value="this")
        private boolean stopped = false;
        @GuardedBy(value="this")
        private boolean networkInitialised = false;
        @GuardedBy(value="this")
        private boolean networkEnabled = false;
        @GuardedBy(value="this")
        private boolean paddingEnabled = false;
        @GuardedBy(value="this")
        private boolean ipv6Enabled = false;
        @GuardedBy(value="this")
        private boolean circuitBuilt = false;
        @GuardedBy(value="this")
        private int bootstrapPercentage = 0;
        @GuardedBy(value="this")
        private List<String> bridges = Collections.emptyList();
        @GuardedBy(value="this")
        private int orConnectionsConnected = 0;
        @Nullable
        @GuardedBy(value="this")
        private TorWrapper.TorState state = null;

        private NetworkState() {
        }

        private synchronized void setObserver(@Nullable TorWrapper.Observer observer) {
            this.observer = observer;
        }

        @GuardedBy(value="this")
        private void updateState() {
            TorWrapper.TorState newState = this.getState();
            if (newState != this.state) {
                this.state = newState;
                if (this.observer != null) {
                    AbstractTorWrapper.this.eventExecutor.execute(() -> this.observer.onState(newState));
                }
            }
        }

        private synchronized void setStarted() {
            this.started = true;
            this.updateState();
        }

        private synchronized boolean isTorRunning() {
            return this.started && !this.stopped;
        }

        private synchronized void setStopped() {
            this.stopped = true;
            this.updateState();
        }

        private synchronized void setBootstrapPercentage(int percentage) {
            if (percentage == this.bootstrapPercentage) {
                return;
            }
            this.bootstrapPercentage = percentage;
            if (this.observer != null) {
                AbstractTorWrapper.this.eventExecutor.execute(() -> this.observer.onBootstrapPercentage(percentage));
            }
            this.updateState();
        }

        private synchronized boolean setCircuitBuilt(boolean built) {
            if (built == this.circuitBuilt) {
                return false;
            }
            this.circuitBuilt = built;
            this.updateState();
            return true;
        }

        private synchronized boolean enableNetwork(boolean enable) {
            boolean wasInitialised = this.networkInitialised;
            boolean wasEnabled = this.networkEnabled;
            this.networkInitialised = true;
            this.networkEnabled = enable;
            if (!enable) {
                this.circuitBuilt = false;
            }
            if (!wasInitialised || enable != wasEnabled) {
                this.updateState();
            }
            return enable != wasEnabled;
        }

        private synchronized boolean enableConnectionPadding(boolean enable) {
            if (enable == this.paddingEnabled) {
                return false;
            }
            this.paddingEnabled = enable;
            return true;
        }

        private synchronized boolean enableIpv6(boolean enable) {
            if (enable == this.ipv6Enabled) {
                return false;
            }
            this.ipv6Enabled = enable;
            return true;
        }

        private synchronized boolean setBridges(List<String> bridges) {
            if (this.bridges.equals(bridges)) {
                return false;
            }
            this.bridges = bridges;
            return true;
        }

        private synchronized TorWrapper.TorState getState() {
            if (!this.started || this.stopped) {
                return TorWrapper.TorState.STARTING_STOPPING;
            }
            if (!this.networkInitialised) {
                return TorWrapper.TorState.CONNECTING;
            }
            if (!this.networkEnabled) {
                return TorWrapper.TorState.DISABLED;
            }
            return this.bootstrapPercentage == 100 && this.circuitBuilt && this.orConnectionsConnected > 0 ? TorWrapper.TorState.CONNECTED : TorWrapper.TorState.CONNECTING;
        }

        private synchronized void onOrConnectionConnected() {
            int oldConnected = this.orConnectionsConnected++;
            this.logOrConnections();
            if (oldConnected == 0) {
                this.updateState();
            }
        }

        private synchronized void onOrConnectionClosed() {
            int oldConnected = this.orConnectionsConnected--;
            if (this.orConnectionsConnected < 0) {
                TorWrapper.LOG.warning("Count was zero before connection closed");
                this.orConnectionsConnected = 0;
            }
            this.logOrConnections();
            if (this.orConnectionsConnected == 0 && oldConnected != 0) {
                this.updateState();
            }
        }

        @GuardedBy(value="this")
        private void logOrConnections() {
            if (TorWrapper.LOG.isLoggable(Level.INFO)) {
                TorWrapper.LOG.info(this.orConnectionsConnected + " OR connections connected");
            }
        }

        private synchronized void onHsDescriptorUploaded(String onion) {
            if (this.observer != null) {
                AbstractTorWrapper.this.eventExecutor.execute(() -> this.observer.onHsDescriptorUpload(onion));
            }
        }

        private synchronized void onClockSkewDetected(long skewSeconds) {
            if (this.observer != null) {
                AbstractTorWrapper.this.eventExecutor.execute(() -> this.observer.onClockSkewDetected(skewSeconds));
            }
        }
    }
}

