/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.onionwrapper.TorWrapper;

@NotNullByDefault
class TorUtils {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    TorUtils() {
    }

    static String scrubOnion(String onion) {
        return onion.substring(0, 3) + "[scrubbed]";
    }

    static void copyAndClose(InputStream in, OutputStream out) {
        byte[] buf = new byte[4096];
        try {
            int read;
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            TorUtils.tryToClose(in, TorWrapper.LOG, Level.WARNING);
            TorUtils.tryToClose(out, TorWrapper.LOG, Level.WARNING);
        }
    }

    static void tryToClose(@Nullable Closeable c, Logger logger, Level level) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            TorUtils.logException(logger, level, e);
        }
    }

    static void tryToClose(@Nullable Socket s, Logger logger, Level level) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (IOException e) {
            TorUtils.logException(logger, level, e);
        }
    }

    private static void logException(Logger logger, Level level, Throwable t) {
        if (logger.isLoggable(level)) {
            logger.log(level, t.toString(), t);
        }
    }
}

