/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper.util;

import javax.annotation.Nullable;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.onionwrapper.util.StringUtils;

@NotNullByDefault
public class OsUtils {
    @Nullable
    private static final String os = System.getProperty("os.name");
    @Nullable
    private static final String vendor = System.getProperty("java.vendor");

    public static boolean isWindows() {
        return os != null && StringUtils.startsWithIgnoreCase(os, "Win");
    }

    public static boolean isMac() {
        return os != null && os.equalsIgnoreCase("Mac OS X");
    }

    public static boolean isLinux() {
        return os != null && StringUtils.startsWithIgnoreCase(os, "Linux") && !OsUtils.isAndroid();
    }

    public static boolean isAndroid() {
        return vendor != null && vendor.contains("Android");
    }
}

