/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.briarproject.nullsafety.NotNullByDefault;

@NotNullByDefault
public interface TorWrapper {
    public static final Logger LOG = Logger.getLogger(TorWrapper.class.getName());

    public void start() throws IOException, InterruptedException;

    public void stop() throws IOException, InterruptedException;

    public void setObserver(@Nullable Observer var1);

    public TorState getTorState();

    public boolean isTorRunning();

    public HiddenServiceProperties publishHiddenService(int var1, int var2, @Nullable String var3) throws IOException;

    public void removeHiddenService(String var1) throws IOException;

    public void enableNetwork(boolean var1) throws IOException;

    public void enableBridges(List<String> var1) throws IOException;

    public void disableBridges() throws IOException;

    public void enableConnectionPadding(boolean var1) throws IOException;

    public void enableIpv6(boolean var1) throws IOException;

    public File getObfs4ExecutableFile();

    public static class HiddenServiceProperties {
        public final String onion;
        public final String privKey;

        HiddenServiceProperties(String onion, String privKey) {
            this.onion = onion;
            this.privKey = privKey;
        }
    }

    public static interface Observer {
        public void onState(TorState var1);

        public void onBootstrapPercentage(int var1);

        public void onHsDescriptorUpload(String var1);

        public void onClockSkewDetected(long var1);
    }

    public static enum TorState {
        NOT_STARTED,
        STARTING,
        STARTED,
        CONNECTING,
        CONNECTED,
        DISABLED,
        STOPPING,
        STOPPED;

    }
}

