/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.onionwrapper;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import javax.inject.Inject;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;
import org.briarproject.onionwrapper.CircumventionProvider;

@NotNullByDefault
@Immutable
class CircumventionProviderImpl
implements CircumventionProvider {
    private static final String DEFAULT_COUNTRY_CODE = "ZZ";
    private static final Set<String> USE_DEFAULT_OBFS4 = new HashSet<String>(Arrays.asList(COUNTRIES_DEFAULT_OBFS4));
    private static final Set<String> USE_NON_DEFAULT_OBFS4 = new HashSet<String>(Arrays.asList(COUNTRIES_NON_DEFAULT_OBFS4));
    private static final Set<String> USE_VANILLA = new HashSet<String>(Arrays.asList(COUNTRIES_VANILLA));
    private static final Set<String> USE_MEEK = new HashSet<String>(Arrays.asList(COUNTRIES_MEEK));
    private static final Set<String> USE_SNOWFLAKE = new HashSet<String>(Arrays.asList(COUNTRIES_SNOWFLAKE));

    @Inject
    CircumventionProviderImpl() {
    }

    @Override
    public boolean shouldUseBridges(String countryCode) {
        return USE_DEFAULT_OBFS4.contains(countryCode) || USE_NON_DEFAULT_OBFS4.contains(countryCode) || USE_VANILLA.contains(countryCode) || USE_MEEK.contains(countryCode) || USE_SNOWFLAKE.contains(countryCode);
    }

    @Override
    public List<CircumventionProvider.BridgeType> getSuitableBridgeTypes(String countryCode) {
        ArrayList<CircumventionProvider.BridgeType> types = new ArrayList<CircumventionProvider.BridgeType>();
        if (USE_DEFAULT_OBFS4.contains(countryCode)) {
            types.add(CircumventionProvider.BridgeType.DEFAULT_OBFS4);
        }
        if (USE_NON_DEFAULT_OBFS4.contains(countryCode)) {
            types.add(CircumventionProvider.BridgeType.NON_DEFAULT_OBFS4);
        }
        if (USE_VANILLA.contains(countryCode)) {
            types.add(CircumventionProvider.BridgeType.VANILLA);
        }
        if (USE_MEEK.contains(countryCode)) {
            types.add(CircumventionProvider.BridgeType.MEEK);
        }
        if (USE_SNOWFLAKE.contains(countryCode)) {
            types.add(CircumventionProvider.BridgeType.SNOWFLAKE);
        }
        if (types.isEmpty()) {
            types.add(CircumventionProvider.BridgeType.DEFAULT_OBFS4);
            types.add(CircumventionProvider.BridgeType.VANILLA);
        }
        return types;
    }

    @Override
    public List<String> getBridges(CircumventionProvider.BridgeType type, String countryCode) {
        String filename;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(filename = this.makeResourceFilename(type, countryCode));
        if (is == null) {
            filename = this.makeResourceFilename(type, DEFAULT_COUNTRY_CODE);
            is = (InputStream)NullSafety.requireNonNull((Object)cl.getResourceAsStream(filename));
        }
        ArrayList<String> bridges = new ArrayList<String>();
        Scanner scanner = new Scanner(is);
        while (scanner.hasNextLine()) {
            bridges.add("Bridge " + scanner.nextLine());
        }
        scanner.close();
        return bridges;
    }

    private String makeResourceFilename(CircumventionProvider.BridgeType type, String countryCode) {
        return "bridges-" + type.letter + "-" + countryCode.toLowerCase(Locale.US);
    }
}

