/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.socks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.nullsafety.NullSafety;
import org.briarproject.util.ByteUtils;
import org.briarproject.util.IoUtils;

@NotNullByDefault
class SocksSocket
extends Socket {
    private static final String[] ERRORS = new String[]{"Succeeded", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    private static final byte[] UNSPECIFIED_ADDRESS = new byte[4];
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final SocketAddress proxy;
    private final int connectToProxyTimeout;
    private final int extraConnectTimeout;
    private final int extraSocketTimeout;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    SocksSocket(SocketAddress proxy, int connectToProxyTimeout, int extraConnectTimeout, int extraSocketTimeout, String username, String password) {
        this.proxy = proxy;
        this.connectToProxyTimeout = connectToProxyTimeout;
        this.extraConnectTimeout = extraConnectTimeout;
        this.extraSocketTimeout = extraSocketTimeout;
        this.username = username;
        this.password = password;
    }

    SocksSocket(SocketAddress proxy, int connectToProxyTimeout, int extraConnectTimeout, int extraSocketTimeout) {
        this.proxy = proxy;
        this.connectToProxyTimeout = connectToProxyTimeout;
        this.extraConnectTimeout = extraConnectTimeout;
        this.extraSocketTimeout = extraSocketTimeout;
        this.username = null;
        this.password = null;
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (!(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException();
        }
        InetSocketAddress inet = (InetSocketAddress)endpoint;
        InetAddress address = inet.getAddress();
        if (address != null && !Arrays.equals(address.getAddress(), UNSPECIFIED_ADDRESS)) {
            throw new IllegalArgumentException();
        }
        String host = inet.getHostName();
        if (host.length() > 255) {
            throw new IllegalArgumentException();
        }
        int port = inet.getPort();
        super.connect(this.proxy, this.connectToProxyTimeout);
        OutputStream out = IoUtils.getOutputStream(this);
        InputStream in = IoUtils.getInputStream(this);
        this.sendMethodRequest(out);
        this.receiveMethodResponse(in);
        if (this.username != null && this.password != null) {
            this.sendAuthRequest(out);
            this.receiveAuthResponse(in);
        }
        int oldTimeout = this.getSoTimeout();
        this.setSoTimeout(timeout + this.extraConnectTimeout);
        this.sendConnectRequest(out, host, port);
        this.receiveConnectResponse(in);
        this.setSoTimeout(oldTimeout + this.extraSocketTimeout);
    }

    private void sendMethodRequest(OutputStream out) throws IOException {
        byte method = this.username == null || this.password == null ? (byte)0 : 2;
        byte[] methodRequest = new byte[]{5, 1, method};
        out.write(methodRequest);
        out.flush();
    }

    private void receiveMethodResponse(InputStream in) throws IOException {
        byte[] methodResponse = new byte[2];
        IoUtils.readFully(in, methodResponse);
        byte version = methodResponse[0];
        byte method = methodResponse[1];
        if (version != 5) {
            throw new IOException("Unsupported SOCKS version: " + version);
        }
        if (method == -1) {
            throw new IOException("Proxy requires authentication");
        }
        byte requestedMethod = this.username == null || this.password == null ? (byte)0 : 2;
        if (method != requestedMethod) {
            throw new IOException("Unsupported auth method: " + method);
        }
    }

    private void sendAuthRequest(OutputStream out) throws IOException {
        byte[] usernameBytes = ((String)NullSafety.requireNonNull((Object)this.username)).getBytes(UTF_8);
        byte[] passwordBytes = ((String)NullSafety.requireNonNull((Object)this.password)).getBytes(UTF_8);
        byte[] authRequest = new byte[3 + usernameBytes.length + passwordBytes.length];
        authRequest[0] = 1;
        authRequest[1] = (byte)usernameBytes.length;
        System.arraycopy(usernameBytes, 0, authRequest, 2, usernameBytes.length);
        authRequest[usernameBytes.length + 2] = (byte)passwordBytes.length;
        System.arraycopy(passwordBytes, 0, authRequest, usernameBytes.length + 3, passwordBytes.length);
        out.write(authRequest);
        out.flush();
    }

    private void receiveAuthResponse(InputStream in) throws IOException {
        byte[] authResponse = new byte[2];
        IoUtils.readFully(in, authResponse);
        byte version = authResponse[0];
        byte status = authResponse[1];
        if (version != 1) {
            throw new IOException("Unsupported subnegotiation version: " + version);
        }
        if (status != 0) {
            throw new IOException("Authentication failed, status: " + status);
        }
    }

    private void sendConnectRequest(OutputStream out, String host, int port) throws IOException {
        byte[] connectRequest = new byte[7 + host.length()];
        connectRequest[0] = 5;
        connectRequest[1] = 1;
        connectRequest[3] = 3;
        connectRequest[4] = (byte)host.length();
        for (int i = 0; i < host.length(); ++i) {
            connectRequest[5 + i] = (byte)host.charAt(i);
        }
        ByteUtils.writeUint16(port, connectRequest, connectRequest.length - 2);
        out.write(connectRequest);
        out.flush();
    }

    private void receiveConnectResponse(InputStream in) throws IOException {
        byte[] connectResponse = new byte[4];
        IoUtils.readFully(in, connectResponse);
        int version = connectResponse[0] & 0xFF;
        int reply = connectResponse[1] & 0xFF;
        int addressType = connectResponse[3] & 0xFF;
        if (version != 5) {
            throw new IOException("Unsupported SOCKS version: " + version);
        }
        if (reply != 0) {
            if (reply < ERRORS.length) {
                throw new IOException("Connection failed: " + ERRORS[reply]);
            }
            throw new IOException("Connection failed: " + reply);
        }
        if (addressType == 1) {
            IoUtils.readFully(in, new byte[4]);
        } else if (addressType == 4) {
            IoUtils.readFully(in, new byte[16]);
        } else {
            throw new IOException("Unsupported address type: " + addressType);
        }
        IoUtils.readFully(in, new byte[2]);
    }
}

