/*
 * Decompiled with CFR 0.152.
 */
package org.briarproject.socks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.briarproject.nullsafety.NotNullByDefault;
import org.briarproject.socks.SocksSocket;

@NotNullByDefault
public class SocksSocketFactory
extends SocketFactory {
    private final SocketAddress proxy;
    private final int connectToProxyTimeout;
    private final int extraConnectTimeout;
    private final int extraSocketTimeout;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    public SocksSocketFactory(SocketAddress proxy, int connectToProxyTimeout, int extraConnectTimeout, int extraSocketTimeout, String username, String password) {
        this.proxy = proxy;
        this.connectToProxyTimeout = connectToProxyTimeout;
        this.extraConnectTimeout = extraConnectTimeout;
        this.extraSocketTimeout = extraSocketTimeout;
        this.username = username;
        this.password = password;
    }

    public SocksSocketFactory(SocketAddress proxy, int connectToProxyTimeout, int extraConnectTimeout, int extraSocketTimeout) {
        this.proxy = proxy;
        this.connectToProxyTimeout = connectToProxyTimeout;
        this.extraConnectTimeout = extraConnectTimeout;
        this.extraSocketTimeout = extraSocketTimeout;
        this.username = null;
        this.password = null;
    }

    @Override
    public Socket createSocket() {
        if (this.username == null || this.password == null) {
            return new SocksSocket(this.proxy, this.connectToProxyTimeout, this.extraConnectTimeout, this.extraSocketTimeout);
        }
        return new SocksSocket(this.proxy, this.connectToProxyTimeout, this.extraConnectTimeout, this.extraSocketTimeout, this.username, this.password);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.createSocket();
        socket.connect(InetSocketAddress.createUnresolved(host, port));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException();
    }
}

