/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.seam;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.SocialAuthConfig;
import org.brickred.socialauth.SocialAuthManager;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.Redirect;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Name(value="socialauth")
@Install(precedence=0)
@Scope(value=ScopeType.SESSION)
public class SocialAuth
implements Serializable {
    private static final long serialVersionUID = 1789108831048043099L;
    private transient LogProvider log = Logging.getLogProvider(SocialAuth.class);
    private String id;
    private AuthProvider provider;
    private String status;
    private String viewUrl;
    private SocialAuthManager manager;
    private SocialAuthConfig config;

    @Create
    public void init() {
        this.id = null;
        this.provider = null;
        this.config = new SocialAuthConfig();
        try {
            this.config.load();
            this.manager = new SocialAuthManager();
            this.manager.setSocialAuthConfig(this.config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getViewUrl() {
        return this.viewUrl;
    }

    private String returnToUrl() throws MalformedURLException {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        URL returnToUrl = request.getServerPort() == 80 ? new URL("http", request.getServerName(), context.getApplication().getViewHandler().getActionURL(context, this.viewUrl)) : new URL("http", request.getServerName(), request.getServerPort(), context.getApplication().getViewHandler().getActionURL(context, this.viewUrl));
        return returnToUrl.toExternalForm();
    }

    public void login() throws Exception {
        String returnToUrl = this.returnToUrl();
        String url = this.manager.getAuthenticationUrl(this.id, returnToUrl);
        this.log.info((Object)("Redirecting to:" + url));
        if (url != null) {
            Redirect redirect = Redirect.instance();
            redirect.captureCurrentView();
            FacesManager.instance().redirectToExternalURL(url);
        }
    }

    public void connect() throws Exception {
        this.log.info((Object)("Connecting Provider:" + this.id));
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        this.provider = this.manager.connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
    }

    public void logout() {
        this.init();
    }

    public Profile getProfile() throws Exception {
        return this.provider.getUserProfile();
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void updateStatus() throws Exception {
        this.provider.updateStatus(this.status);
    }

    public List<Contact> getContactList() throws Exception {
        return this.provider.getContactList();
    }

    public Profile getUserProfile() throws Exception {
        return this.provider.getUserProfile();
    }

    public List<String> getConnectedProvidersIds() {
        return this.manager.getConnectedProvidersIds();
    }

    public SocialAuthManager getSocialAuthManager() {
        return this.manager;
    }
}

