/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.spring.controller;

import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.AuthProviderFactory;
import org.brickred.socialauth.spring.bean.SocialAuthTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/socialauth"})
public class SocialAuthWebController {
    private String baseCallbackUrl;
    private String successPageURL;
    private Properties properites;
    @Autowired
    private SocialAuthTemplate socialAuthTemplate;

    @Inject
    public SocialAuthWebController(String applicationUrl, String successPageURL, Properties socialAuthProperties) {
        this.baseCallbackUrl = applicationUrl;
        this.successPageURL = successPageURL;
        this.properites = socialAuthProperties;
    }

    @RequestMapping(params={"id"})
    public String connect(@RequestParam(value="id") String providerId, HttpServletRequest request) throws Exception {
        AuthProvider provider = AuthProviderFactory.getInstance((String)providerId, (Properties)this.properites);
        String url = provider.getLoginRedirectURL(this.baseCallbackUrl + request.getServletPath());
        this.socialAuthTemplate.setProvider(provider);
        return "redirect:" + url;
    }

    @RequestMapping(params={"oauth_token"})
    public String oauthCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"code"})
    public String oauth2Callback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"wrap_verification_code"})
    public String hotmailCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    @RequestMapping(params={"openid.claimed_id"})
    public String openidCallback(HttpServletRequest request) {
        this.callback(request);
        return "redirect:/" + this.successPageURL;
    }

    private void callback(HttpServletRequest request) {
        AuthProvider provider = this.socialAuthTemplate.getProvider();
        if (provider != null) {
            try {
                provider.verifyResponse(request);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

