/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.examples;

import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.bio.DataSourceTxt;

public class ExampleWithBridgeDb {
    private void domapping(String connectString, String id, DataSource src, DataSource dest) throws IDMapperException {
        IDMapper mapper = BridgeDb.connect((String)connectString);
        Xref srcRef = new Xref(id, src);
        for (Xref destRef : mapper.mapID(srcRef, new DataSource[]{dest})) {
            System.out.println("  " + destRef);
        }
    }

    private void run() throws ClassNotFoundException, IDMapperException {
        DataSourceTxt.init();
        String id = "3643";
        Class.forName("org.bridgedb.webservice.cronos.IDMapperCronos");
        this.domapping("idmapper-cronos:hsa", "3643", BioDataSource.ENTREZ_GENE, BioDataSource.ENSEMBL_HUMAN);
        Class.forName("org.bridgedb.webservice.synergizer.IDMapperSynergizer");
        this.domapping("idmapper-synergizer:?authority=ensembl&species=Homo sapiens", id, DataSource.getByFullName((String)"entrezgene"), DataSource.getByFullName((String)"ensembl_gene_id"));
    }

    public static void main(String[] args) throws ClassNotFoundException, IDMapperException {
        ExampleWithBridgeDb main = new ExampleWithBridgeDb();
        main.run();
    }
}

