/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bridgedb.utils.BridgeDBException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;

public abstract class RdfBase {
    public static String DEFAULT_BASE_URI = "http://no/BaseURI/Set/";
    public static RDFFormat DEFAULT_FILE_FORMAT = RDFFormat.TURTLE;
    private static final Logger logger = Logger.getLogger(RdfBase.class);

    static String scrub(String original) {
        String result = original.replaceAll("\\W", "_");
        while (result.contains("__")) {
            result = result.replace("__", "_");
        }
        if (result.endsWith("_")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static String convertToShortName(Value value) {
        String id = value.stringValue();
        id = id.replace(DEFAULT_BASE_URI, ":");
        return id;
    }

    public static String getSingletonString(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws BridgeDBException, RepositoryException {
        String result = RdfBase.getPossibleSingletonString(repositoryConnection, id, predicate);
        if (result == null) {
            throw new BridgeDBException("No statement found with resource " + id + " and predicate " + predicate);
        }
        return result;
    }

    public static String getPossibleSingletonString(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws RepositoryException, BridgeDBException {
        Value result = RdfBase.getPossibleSingleton(repositoryConnection, id, predicate);
        if (result == null) {
            return null;
        }
        return result.stringValue();
    }

    static Resource getPossibleSingletonResource(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws RepositoryException, BridgeDBException {
        Value value = RdfBase.getPossibleSingleton(repositoryConnection, id, predicate);
        return RdfBase.toResource(value);
    }

    private static Resource toResource(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Resource) {
            return (Resource)value;
        }
        return new URIImpl(value.stringValue());
    }

    static Value getPossibleSingleton(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws RepositoryException, BridgeDBException {
        RepositoryResult statements = repositoryConnection.getStatements(id, predicate, null, true, new Resource[0]);
        if (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            if (statements.hasNext()) {
                throw new BridgeDBException("Found more than one statement with resource " + id + " and predicate " + predicate + "\nFound: " + statement + "\n\t" + statements.next());
            }
            return statement.getObject();
        }
        return null;
    }

    static Set<String> getAllStrings(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws RepositoryException {
        HashSet<String> results = new HashSet<String>();
        RepositoryResult statements = repositoryConnection.getStatements(id, predicate, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            results.add(statement.getObject().stringValue());
        }
        return results;
    }

    static Set<Resource> getAllResources(RepositoryConnection repositoryConnection, Resource id, URI predicate) throws RepositoryException {
        HashSet<Resource> results = new HashSet<Resource>();
        RepositoryResult statements = repositoryConnection.getStatements(id, predicate, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Value value = statement.getObject();
            if (value == null) continue;
            results.add(RdfBase.toResource(value));
        }
        return results;
    }

    public static void shutDown(Repository repository, RepositoryConnection repositoryConnection) {
        if (repositoryConnection != null) {
            try {
                repositoryConnection.close();
            }
            catch (RepositoryException ex) {
                logger.error((Object)"Error closing connection", (Throwable)ex);
            }
        }
        if (repository != null) {
            try {
                repository.shutDown();
            }
            catch (RepositoryException ex) {
                logger.error((Object)"Error shutting down repository", (Throwable)ex);
            }
        }
    }
}

