/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf.create;

import info.aduna.lang.FileFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class LinkSetCombiner {
    public static String DEFAULT_BASE_URI = "http://no/BaseURI/Set/";

    private static RDFFormat getFormat(String fileName) throws BridgeDBException {
        RDFParserRegistry reg;
        FileFormat fileFormat;
        if (fileName.endsWith(".n3")) {
            fileName = "try.ttl";
        }
        if ((fileFormat = (reg = RDFParserRegistry.getInstance()).getFileFormatForFileName(fileName)) == null || !(fileFormat instanceof RDFFormat)) {
            throw new BridgeDBException("failed");
        }
        return (RDFFormat)fileFormat;
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, File file) throws IOException, RDFHandlerException, RepositoryException {
        FileWriter writer = new FileWriter(file);
        TurtleWriter turtleWriter = new TurtleWriter((Writer)writer);
        LinkSetCombiner.writeRDF(repositoryConnection, (RDFWriter)turtleWriter);
        ((Writer)writer).close();
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, RDFWriter rdfWriter) throws IOException, RDFHandlerException, RepositoryException {
        rdfWriter.handleNamespace("bdb", "http://vocabularies.bridgedb.org/ops#");
        rdfWriter.handleNamespace("", DEFAULT_BASE_URI);
        rdfWriter.startRDF();
        RepositoryResult statements = repositoryConnection.getStatements(null, null, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            rdfWriter.handleStatement(statement);
        }
        rdfWriter.endRDF();
    }

    public static void convert(Collection<File> inputFiles, File outputFile) throws Exception {
        SailRepository repository = null;
        try (RepositoryConnection repositoryConnection = null;){
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            for (File inputFile : inputFiles) {
                Reporter.println((String)("Parsing " + inputFile.getAbsolutePath()));
                repositoryConnection.add(inputFile, DEFAULT_BASE_URI, LinkSetCombiner.getFormat(inputFile.getName()), new Resource[0]);
            }
            LinkSetCombiner.writeRDF(repositoryConnection, outputFile);
        }
    }

    public static long count(File inputFile) throws Exception {
        SailRepository repository = null;
        try (RepositoryConnection repositoryConnection = null;){
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            Reporter.println((String)("Parsing (to count)" + inputFile.getAbsolutePath()));
            repositoryConnection.add(inputFile, DEFAULT_BASE_URI, LinkSetCombiner.getFormat(inputFile.getName()), new Resource[0]);
            long result = repositoryConnection.size(new Resource[0]);
            System.out.println("Count is " + result);
            long l = result;
            return l;
        }
    }

    public static void main(String[] args) throws Exception {
        long total = 0L;
        HashSet<File> files = new HashSet<File>();
        File f1 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/CHEBI/LINKSET_EXACT_OPS_CHEMSPIDER_CHEBI20131111.ttl");
        total += LinkSetCombiner.count(f1);
        files.add(f1);
        File f2 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/CHEMBL/LINKSET_EXACT_OPS_CHEMSPIDER_CHEMBL20131111.ttl");
        total += LinkSetCombiner.count(f2);
        files.add(f2);
        File f3 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/DRUGBANK/LINKSET_EXACT_OPS_CHEMSPIDER_DRUGBANK20131111.ttl");
        total += LinkSetCombiner.count(f3);
        files.add(f3);
        File f4 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/HMDB/LINKSET_EXACT_OPS_CHEMSPIDER_HMDB20131111.ttl");
        total += LinkSetCombiner.count(f4);
        files.add(f4);
        File f5 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/MESH/LINKSET_EXACT_OPS_CHEMSPIDER_MESH20131111.ttl");
        total += LinkSetCombiner.count(f5);
        files.add(f5);
        File f6 = new File("C:/Dropbox/ims/linkset/version1.3/CRS/PDB/LINKSET_EXACT_OPS_CHEMSPIDER_PDB20131111.ttl");
        total += LinkSetCombiner.count(f6);
        files.add(f6);
        File fresult = new File("C:/Temp/CRS_combined.ttl");
        LinkSetCombiner.convert(files, fresult);
        long combined = LinkSetCombiner.count(fresult);
        System.out.println("Detected " + (combined - total) + " duplicates");
    }
}

