/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public class BridgeDbRdfTools {
    static final Logger logger = Logger.getLogger(BridgeDbRdfTools.class);
    public static final String DEFAULT_FORMAT = "TriX";

    public static String writeRDF(Set<Statement> statements, String formatName) throws BridgeDBException {
        StringWriter writer = new StringWriter();
        if (formatName == null) {
            formatName = DEFAULT_FORMAT;
        }
        RDFFormat rdfFormat = RDFFormat.valueOf((String)formatName);
        BridgeDbRdfTools.writeRDF(statements, rdfFormat, writer);
        return writer.toString();
    }

    public static void writeRDF(Set<Statement> statements, RDFFormat format, Writer writer) throws BridgeDBException {
        RDFWriter rdfWriter = null;
        if (format != null) {
            rdfWriter = BridgeDbRdfTools.getWriterIfPossible(format, writer);
        }
        try {
            if (rdfWriter != null) {
                rdfWriter.startRDF();
                rdfWriter.handleNamespace("ops", RdfBase.DEFAULT_BASE_URI);
                rdfWriter.handleNamespace("void", "http://rdfs.org/ns/void#");
                rdfWriter.handleNamespace("dul", "http://www.ontologydesignpatterns.org/ont/dul/DUL.owl#");
                for (Statement statement : statements) {
                    rdfWriter.handleStatement(statement);
                }
                rdfWriter.endRDF();
            } else {
                writer.flush();
                writer.write("No Writer available for format: " + format + "\n");
            }
        }
        catch (RDFHandlerException ex) {
            throw new BridgeDBException("Error writing RDF. ", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new BridgeDBException("Error writing RDF. ", (Throwable)ex);
        }
    }

    public static Set<String> getAvaiableWriters() {
        Object n = null;
        Object nt = null;
        Object x2 = null;
        Object x = null;
        Object tr = null;
        Object tw = null;
        Object t = null;
        HashSet<String> results = new HashSet<String>();
        StringWriter writer = new StringWriter();
        for (RDFFormat rdfFormat : RDFFormat.values()) {
            RDFWriter rdfWriter = BridgeDbRdfTools.getWriterIfPossible(rdfFormat, writer);
            if (rdfWriter == null) continue;
            results.add(rdfFormat.getName());
        }
        return results;
    }

    public static Set<RDFFormat> getAvaiableFormats() {
        HashSet<RDFFormat> results = new HashSet<RDFFormat>();
        StringWriter writer = new StringWriter();
        for (RDFFormat rdfFormat : RDFFormat.values()) {
            RDFWriter rdfWriter = BridgeDbRdfTools.getWriterIfPossible(rdfFormat, writer);
            if (rdfWriter == null) continue;
            results.add(rdfFormat);
        }
        return results;
    }

    private static RDFWriter getWriterIfPossible(RDFFormat format, Writer writer) {
        RDFWriterRegistry register = RDFWriterRegistry.getInstance();
        RDFWriterFactory factory = (RDFWriterFactory)register.get((Object)format);
        if (factory == null) {
            return null;
        }
        try {
            return factory.getWriter(writer);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            return null;
        }
    }

    public static void main(String[] args) {
        Reporter.println((String)BridgeDbRdfTools.getAvaiableWriters().toString());
    }
}

