/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.bridgedb.bio.Organism;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.rdf.constants.BridgeDBConstants;
import org.bridgedb.rdf.constants.RdfConstants;
import org.bridgedb.utils.BridgeDBException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class OrganismRdf
extends RdfBase {
    private static OrganismRdf singleton = null;
    private HashMap<Value, Object> organisms = new HashMap();

    private OrganismRdf() {
        for (Organism organism : Organism.values()) {
            this.organisms.put((Value)OrganismRdf.getResourceId(organism), organism);
        }
    }

    public static OrganismRdf factory() {
        if (singleton == null) {
            singleton = new OrganismRdf();
        }
        return singleton;
    }

    public static final String getRdfLabel(Organism organism) {
        return OrganismRdf.scrub(organism.code());
    }

    public static final URI getResourceId(Organism organism) {
        return new URIImpl("http://vocabularies.bridgedb.org/ops#Organism_" + OrganismRdf.getRdfLabel(organism));
    }

    public static void addAll(RepositoryConnection repositoryConnection) throws IOException, RepositoryException {
        for (Organism organism : Organism.values()) {
            OrganismRdf.add(repositoryConnection, organism);
        }
    }

    public void addComments(RDFHandler handler) throws RDFHandlerException {
        handler.handleComment("WARNING: Organism are hard coded into BridgeDB.");
        handler.handleComment("WARNING: below is for reference and NON BridgeDB use only!");
        handler.handleComment("WARNING: Any changes could cause a BridgeDBException.");
    }

    public static void add(RepositoryConnection repositoryConnection, Organism organism) throws IOException, RepositoryException {
        URI id = OrganismRdf.getResourceId(organism);
        repositoryConnection.add((Resource)id, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.ORGANISM_URI, new Resource[0]);
        repositoryConnection.add((Resource)id, BridgeDBConstants.CODE_URI, (Value)new LiteralImpl(organism.code()), new Resource[0]);
        repositoryConnection.add((Resource)id, BridgeDBConstants.SHORT_NAME_URI, (Value)new LiteralImpl(organism.shortName()), new Resource[0]);
        repositoryConnection.add((Resource)id, BridgeDBConstants.LATIN_NAME_URI, (Value)new LiteralImpl(organism.latinName()), new Resource[0]);
    }

    public static Object readRdf(Resource organismId, Set<Statement> allStatements) throws BridgeDBException {
        for (Statement statement : allStatements) {
            if (!statement.getPredicate().equals((Object)BridgeDBConstants.LATIN_NAME_URI)) continue;
            String latinName = statement.getObject().stringValue();
            Organism orgamism = Organism.fromLatinName((String)latinName);
            if (orgamism != null) {
                return orgamism;
            }
            throw new BridgeDBException("No Orgamism with LatinName " + latinName + " for " + organismId);
        }
        throw new BridgeDBException("No Orgamism found for " + organismId);
    }

    static Object byRdfResource(Value organismId) throws BridgeDBException {
        OrganismRdf organismRdf = OrganismRdf.factory();
        Object result = organismRdf.organisms.get(organismId);
        if (result == null) {
            throw new BridgeDBException("No Orgamism known for " + organismId);
        }
        return result;
    }
}

