/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf.identifiers.org;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.rdf.BridgeDBRdfHandler;
import org.bridgedb.rdf.DataSourceMetaDataProvidor;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.rdf.UriPattern;
import org.bridgedb.rdf.UriPatternType;
import org.bridgedb.rdf.constants.DCatConstants;
import org.bridgedb.rdf.constants.IdenitifiersOrgConstants;
import org.bridgedb.rdf.constants.VoidConstants;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.bridgedb.utils.Reporter;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class IdentifersOrgReader
extends RdfBase {
    public static final String UNABLE_TO_CONNECT = "Unable to connect to miriam";
    public static final String LOCAL_MIRAM_REGISTRY = "MiriamRegistry.ttl";
    public static final String MIRAM_REGISTRY_URI = "http://www.ebi.ac.uk/miriam/main/export/registry.ttl";
    private static final Logger logger = Logger.getLogger(IdentifersOrgReader.class);
    private static final Set<String> multiples;
    private static boolean initRun;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParseRdfInputStream(InputStream stream) throws BridgeDBException {
        SailRepository repository = null;
        RepositoryConnection repositoryConnection = null;
        try {
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            repositoryConnection.add(stream, DEFAULT_BASE_URI, DEFAULT_FILE_FORMAT, new Resource[0]);
            Reporter.println((String)"Registry read in. Now loading DataSources");
            this.loadData(repositoryConnection);
        }
        catch (Exception ex) {
            try {
                throw new BridgeDBException("Error parsing RDF inputStream: " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException ex2) {
                    logger.error((Object)"Error closing input Stream", (Throwable)ex2);
                }
                IdentifersOrgReader.shutDown((Repository)repository, repositoryConnection);
                throw throwable;
            }
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            logger.error((Object)"Error closing input Stream", (Throwable)ex);
        }
        IdentifersOrgReader.shutDown((Repository)repository, repositoryConnection);
    }

    public static void fullInit() {
        if (initRun) {
            return;
        }
    }

    public static void init() throws BridgeDBException {
        if (initRun) {
            return;
        }
        try {
            InputStream stream = ConfigReader.getInputStream((String)LOCAL_MIRAM_REGISTRY);
            IdentifersOrgReader reader = new IdentifersOrgReader();
            reader.doParseRdfInputStream(stream);
            stream.close();
            initRun = true;
        }
        catch (UnknownHostException ex) {
            throw new BridgeDBException(UNABLE_TO_CONNECT, (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            throw new BridgeDBException("Error reading miriam registry.", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new BridgeDBException("Error reading miriam registry.", (Throwable)ex);
        }
    }

    public static void saveRegister() throws BridgeDBException {
        try {
            String line;
            URL url = new URL(MIRAM_REGISTRY_URI);
            Reporter.println((String)("Readng " + url));
            InputStream inputStream = url.openStream();
            InputStreamReader inputReader = new InputStreamReader(inputStream);
            BufferedReader inputBuffer = new BufferedReader(inputReader);
            File outputFile = new File("resources/MiriamRegistry.ttl");
            FileWriter outputWriter = new FileWriter(outputFile);
            BufferedWriter outputBuffer = new BufferedWriter(outputWriter);
            while ((line = inputBuffer.readLine()) != null) {
                outputBuffer.write(line + "\n");
            }
            inputBuffer.close();
            outputBuffer.flush();
            outputBuffer.close();
            inputStream.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BridgeDBException("Error saving miriam regisrty ", (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        IdentifersOrgReader.saveRegister();
        UriPattern.refreshUriPatterns();
        IdentifersOrgReader.init();
        UriPattern.refreshUriPatterns();
        File mergedFile = new File("resources/IdentifiersOrgDataSource.ttl");
        BridgeDBRdfHandler.writeRdfToFile(mergedFile);
        BridgeDBRdfHandler.parseRdfFile(mergedFile);
        File textFile = new File("resources/IdentifiersOrgDataSource.txt");
        BufferedWriter writer = new BufferedWriter(new FileWriter(textFile));
        DataSourceTxt.writeToBuffer((BufferedWriter)writer);
        FileInputStream is = new FileInputStream(textFile);
        DataSourceTxt.loadInputStream((InputStream)is);
    }

    private void loadData(RepositoryConnection repositoryConnection) throws Exception {
        int count = 0;
        RepositoryResult statements = repositoryConnection.getStatements(null, VoidConstants.URI_SPACE_URI, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            DataSource dataSource = DataSource.getByIdentiferOrgBase((String)statement.getObject().stringValue());
            Resource catalogRecord = statement.getSubject();
            if (dataSource == null) {
                dataSource = this.readDataSource(repositoryConnection, catalogRecord, statement.getObject().stringValue());
            } else {
                this.compareDataSource(repositoryConnection, catalogRecord, dataSource);
            }
            this.loadExtraDataSourceInfo(repositoryConnection, catalogRecord, dataSource);
            Pattern regex = this.loadRegex(repositoryConnection, catalogRecord, dataSource);
            this.loadUriPatterns(repositoryConnection, catalogRecord, dataSource, regex);
            ++count;
        }
    }

    private DataSource readDataSource(RepositoryConnection repositoryConnection, Resource catalogRecord, String identiferOrgBase) throws Exception {
        String fullName;
        String sysCode = IdentifersOrgReader.getSingletonString(repositoryConnection, catalogRecord, IdenitifiersOrgConstants.NAMESPACE_URI);
        if (sysCode.equals("unipathway")) {
            sysCode = "Up";
        }
        if ((fullName = IdentifersOrgReader.getSingletonString(repositoryConnection, catalogRecord, DCatConstants.TITLE_URI)).equals("UniGene")) {
            fullName = "UniGene number";
        }
        UriPattern identifiersOrgPattern = UriPattern.register(identiferOrgBase + "$id", sysCode, UriPatternType.identifiersOrgPatternSimple);
        String identifersOrgInfoBase = identiferOrgBase.replace("identifiers.org", "info.identifiers.org");
        UriPattern.register(identifersOrgInfoBase + "$id", sysCode, UriPatternType.identifiersOrgPatternInfo);
        DataSource ds = DataSource.register((String)sysCode, (String)fullName).identifiersOrgBase(identiferOrgBase).asDataSource();
        DataSourceMetaDataProvidor.setProvidor(sysCode, DataSourceMetaDataProvidor.MIRIAM_ONLY);
        return ds;
    }

    private void compareDataSource(RepositoryConnection repositoryConnection, Resource catalogRecord, DataSource dataSource) throws Exception {
        String sysCode = IdentifersOrgReader.getSingletonString(repositoryConnection, catalogRecord, IdenitifiersOrgConstants.NAMESPACE_URI);
        String fullName = IdentifersOrgReader.getSingletonString(repositoryConnection, catalogRecord, DCatConstants.TITLE_URI);
        if (!dataSource.getFullName().equals(fullName)) {
            System.err.println("FullName mismatch for " + dataSource.getSystemCode() + " BridgeDb has " + dataSource.getFullName() + " while miriam uses " + fullName);
        }
        if (dataSource.getAlternative() != null && !dataSource.getAlternative().equals(fullName)) {
            System.err.println("Alternative mismatch for " + dataSource.getSystemCode() + " BridgeDb has " + dataSource.getAlternative() + " while miriam uses " + fullName);
        }
    }

    private void loadExtraDataSourceInfo(RepositoryConnection repositoryConnection, Resource catalogRecord, DataSource dataSource) throws RepositoryException, BridgeDBException {
        if (dataSource.getExample().getId() == null) {
            String id = IdentifersOrgReader.getPossibleSingletonString(repositoryConnection, catalogRecord, VoidConstants.EXAMPLE_RESOURCE);
            DataSource.register((String)dataSource.getSystemCode(), (String)dataSource.getFullName()).idExample(id);
        }
    }

    private Pattern loadRegex(RepositoryConnection repositoryConnection, Resource catalogRecord, DataSource dataSource) throws RepositoryException, BridgeDBException {
        Pattern dataSourceRegex;
        String regexSt = IdentifersOrgReader.getPossibleSingletonString(repositoryConnection, catalogRecord, IdenitifiersOrgConstants.REGEX_URI);
        Pattern regex = null;
        if (regexSt != null) {
            regex = Pattern.compile(regexSt);
        }
        if ((dataSourceRegex = (Pattern)DataSourcePatterns.getPatterns().get(dataSource)) != null && !dataSourceRegex.pattern().equals(regex.pattern())) {
            System.err.println("Regex patterns do not match for " + catalogRecord + " was " + regex + " but BridgeBD has " + dataSourceRegex);
        }
        if (regex != null) {
            DataSourcePatterns.registerPattern((DataSource)dataSource, (Pattern)regex);
        }
        return regex;
    }

    private void loadUriPatterns(RepositoryConnection repositoryConnection, Resource CatalogRecord, DataSource dataSource, Pattern regex) throws Exception {
        RepositoryResult statements = repositoryConnection.getStatements(CatalogRecord, DCatConstants.DISTRIBUTION_URI, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Resource Distribution = (Resource)statement.getObject();
            RepositoryResult accessUrlStatements = repositoryConnection.getStatements(Distribution, DCatConstants.ACCESS_URL_URI, null, true, new Resource[0]);
            while (accessUrlStatements.hasNext()) {
                Statement accessUrlStatement = (Statement)accessUrlStatements.next();
                String patternString = accessUrlStatement.getObject().stringValue();
                if (multiples.contains(patternString)) continue;
                UriPattern pattern = UriPattern.register(patternString, dataSource.getSystemCode(), UriPatternType.dataSourceUriPattern);
                String dataSourceSysCode = null;
                if (dataSource == null) continue;
                dataSourceSysCode = dataSource.getSystemCode();
                if (dataSource.getKnownUrl("$id") != null) continue;
                DataSource.register((String)dataSourceSysCode, (String)dataSource.getFullName()).urlPattern(patternString);
            }
        }
    }

    private void checkMultiple(RepositoryConnection repositoryConnection, String multiple) throws Exception {
        URIImpl uri = new URIImpl(multiple);
        RepositoryResult accessStatements = repositoryConnection.getStatements(null, null, (Value)uri, true, new Resource[0]);
        while (accessStatements.hasNext()) {
            Statement accessStatement = (Statement)accessStatements.next();
            Resource distribution = accessStatement.getSubject();
            RepositoryResult distributionStatements = repositoryConnection.getStatements(null, null, (Value)distribution, true, new Resource[0]);
            while (distributionStatements.hasNext()) {
                Statement distributionStatement = (Statement)distributionStatements.next();
                Resource catalog = distributionStatement.getSubject();
                RepositoryResult regexStatements = repositoryConnection.getStatements(catalog, IdenitifiersOrgConstants.REGEX_URI, null, true, new Resource[0]);
                while (regexStatements.hasNext()) {
                    Statement regexStatement = (Statement)regexStatements.next();
                    String string = regexStatement.getObject().stringValue();
                }
            }
        }
    }

    static {
        initRun = false;
        multiples = new HashSet<String>();
        multiples.add("http://linkedchemistry.info/chembl/chemblid/$id");
        multiples.add("http://www.ebi.ac.uk/ena/data/view/$id");
    }
}

