/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.util.HashMap;
import org.bridgedb.DataSource;
import org.bridgedb.utils.BridgeDBException;

public enum DataSourceMetaDataProvidor {
    BIO,
    RDF,
    MIRIAM_ONLY;

    private static HashMap<String, DataSourceMetaDataProvidor> register;

    public static void assumeUnknownsAreBio() {
        for (DataSource dataSource : DataSource.getDataSources()) {
            DataSourceMetaDataProvidor old = register.get(dataSource.getSystemCode());
            if (old != null) continue;
            register.put(dataSource.getSystemCode(), BIO);
        }
    }

    public static void setProvidor(String sysCode, DataSourceMetaDataProvidor providor) {
        DataSourceMetaDataProvidor old = register.get(sysCode);
        if (old != null && old.compareTo(providor) <= 0) {
            return;
        }
        register.put(sysCode, providor);
    }

    public static DataSourceMetaDataProvidor getProvider(String sysCode) throws BridgeDBException {
        if (register.containsKey(sysCode)) {
            return register.get(sysCode);
        }
        throw new BridgeDBException("No provider known for " + sysCode);
    }

    public static int compare(String sysCode1, String sysCode2) throws BridgeDBException {
        DataSourceMetaDataProvidor provider1 = DataSourceMetaDataProvidor.getProvider(sysCode1);
        DataSourceMetaDataProvidor provider2 = DataSourceMetaDataProvidor.getProvider(sysCode2);
        return provider1.compareTo(provider2);
    }

    static {
        register = new HashMap();
    }
}

