/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import info.aduna.lang.FileFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceComparator;
import org.bridgedb.bio.Organism;
import org.bridgedb.rdf.DataSourceMetaDataProvidor;
import org.bridgedb.rdf.OrganismRdf;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.rdf.UriPattern;
import org.bridgedb.rdf.UriPatternType;
import org.bridgedb.rdf.constants.BridgeDBConstants;
import org.bridgedb.rdf.constants.DCTermsConstants;
import org.bridgedb.rdf.constants.DCatConstants;
import org.bridgedb.rdf.constants.RdfConstants;
import org.bridgedb.rdf.pairs.RdfBasedCodeMapper;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.bridgedb.utils.Reporter;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class BridgeDBRdfHandler
extends RdfBase {
    static boolean initialized = false;
    public static final String CONFIG_FILE_NAME = "DataSource.ttl";
    private static final Logger logger = Logger.getLogger(BridgeDBRdfHandler.class);
    private HashMap<Resource, DataSource> dataSourceRegister = new HashMap();
    private HashMap<Resource, UriPattern> uriPatternRegister = new HashMap();

    private BridgeDBRdfHandler() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParseRdfInputStream(InputStream stream) throws BridgeDBException {
        SailRepository repository = null;
        RepositoryConnection repositoryConnection = null;
        try {
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            repositoryConnection.add(stream, DEFAULT_BASE_URI, DEFAULT_FILE_FORMAT, new Resource[0]);
            this.readAllDataSources(repositoryConnection);
            this.readAllUriPatterns(repositoryConnection);
        }
        catch (Exception ex) {
            try {
                throw new BridgeDBException("Error parsing RDF inputStream: " + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException ex2) {
                    logger.error((Object)"Error closing input Stream", (Throwable)ex2);
                }
                BridgeDBRdfHandler.shutDown((Repository)repository, repositoryConnection);
                throw throwable;
            }
        }
        try {
            stream.close();
        }
        catch (IOException ex) {
            logger.error((Object)"Error closing input Stream", (Throwable)ex);
        }
        BridgeDBRdfHandler.shutDown((Repository)repository, repositoryConnection);
    }

    private void readAllDataSources(RepositoryConnection repositoryConnection) throws RepositoryException, BridgeDBException {
        RepositoryResult statements = repositoryConnection.getStatements(null, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.DATA_SOURCE_URI, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Resource dataSourceResource = statement.getSubject();
            DataSource dataSource = this.getDataSource(repositoryConnection, dataSourceResource);
        }
    }

    private DataSource getDataSource(RepositoryConnection repositoryConnection, Resource dataSourceResource) throws BridgeDBException, RepositoryException {
        DataSource result = this.dataSourceRegister.get(dataSourceResource);
        if (result == null) {
            result = this.readDataSource(repositoryConnection, dataSourceResource);
            this.dataSourceRegister.put(dataSourceResource, result);
        }
        return result;
    }

    public DataSource readDataSource(RepositoryConnection repositoryConnection, Resource dataSourceId) throws BridgeDBException, RepositoryException {
        String description;
        String alternative;
        Value identifiersOrgInfoValue;
        Value identifiersOrgSimpleValue;
        String urnBase;
        String type;
        String primary;
        Value organismId;
        String mainUrl;
        String fullName = BridgeDBRdfHandler.getSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.FULL_NAME_URI);
        String systemCode = BridgeDBRdfHandler.getSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.SYSTEM_CODE_URI);
        DataSource.Builder builder = DataSource.register((String)systemCode, (String)fullName);
        String idExample = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.ID_EXAMPLE_URI);
        if (idExample != null) {
            builder.idExample(idExample);
        }
        if ((mainUrl = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.MAIN_URL_URI)) != null) {
            builder.mainUrl(mainUrl);
        }
        if ((organismId = BridgeDBRdfHandler.getPossibleSingleton(repositoryConnection, dataSourceId, BridgeDBConstants.ABOUT_ORGANISM_URI)) != null) {
            Object organism = OrganismRdf.byRdfResource(organismId);
            builder.organism(organism);
        }
        if ((primary = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.PRIMARY_URI)) != null) {
            builder.primary(Boolean.parseBoolean(primary));
        }
        if ((type = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.TYPE_URI)) != null) {
            builder.type(type);
        }
        Value regexValue = BridgeDBRdfHandler.getPossibleSingleton(repositoryConnection, dataSourceId, BridgeDBConstants.HAS_REGEX_PATTERN_URI);
        Pattern regex = null;
        if (regexValue != null) {
            regex = Pattern.compile(regexValue.stringValue());
            DataSourcePatterns.registerPattern((DataSource)builder.asDataSource(), (Pattern)regex);
        } else {
            regex = (Pattern)DataSourcePatterns.getPatterns().get(builder.asDataSource());
        }
        Value urlValue = BridgeDBRdfHandler.getPossibleSingleton(repositoryConnection, dataSourceId, BridgeDBConstants.HAS_PRIMARY_URI_PATTERN_URI);
        if (urlValue != null) {
            UriPattern urlPattern = this.getUriPattern(repositoryConnection, (Resource)urlValue, systemCode, UriPatternType.mainUrlPattern);
            builder.urlPattern(urlPattern.getUriPattern());
        }
        if ((urnBase = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, BridgeDBConstants.URN_BASE_URI)) != null) {
            builder.urnBase(urnBase);
        }
        if ((identifiersOrgSimpleValue = BridgeDBRdfHandler.getPossibleSingleton(repositoryConnection, dataSourceId, BridgeDBConstants.HAS_IDENTIFERS_ORG_PATTERN_URI)) != null) {
            UriPattern identifiersOrgSimplePattern = this.getUriPattern(repositoryConnection, (Resource)identifiersOrgSimpleValue, systemCode, UriPatternType.identifiersOrgPatternSimple);
            String identifiersOrgInfo = identifiersOrgSimplePattern.getUriPattern().replace("identifiers.org", "info.identifiers.org");
            UriPattern identifiersOrgInfoPattern = UriPattern.register(identifiersOrgInfo, systemCode, UriPatternType.identifiersOrgPatternInfo);
            builder.identifiersOrgBase(identifiersOrgSimplePattern.getUriPattern());
        }
        if ((identifiersOrgInfoValue = BridgeDBRdfHandler.getPossibleSingleton(repositoryConnection, dataSourceId, BridgeDBConstants.HAS_IDENTIFERS_ORG_INFO_PATTERN_URI)) != null) {
            UriPattern identifiersOrgInfoPattern = this.getUriPattern(repositoryConnection, (Resource)identifiersOrgInfoValue, systemCode, UriPatternType.identifiersOrgPatternInfo);
            String identifiersOrgSimple = identifiersOrgInfoPattern.getUriPattern().replace("info.identifiers.org", "identifiers.org");
            UriPattern identifiersOrgSimplePattern = UriPattern.register(identifiersOrgSimple, systemCode, UriPatternType.identifiersOrgPatternSimple);
            builder.identifiersOrgBase(identifiersOrgSimplePattern.getUriPattern());
        }
        if ((alternative = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, DCTermsConstants.ALTERNATIVE_URI)) != null) {
            builder.alternative(alternative);
        }
        if ((description = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, dataSourceId, DCatConstants.DESCRIPTION_URI)) != null) {
            builder.description(description);
        }
        this.readUriPatterns(repositoryConnection, dataSourceId, systemCode, UriPatternType.dataSourceUriPattern);
        this.readCodeMapper(repositoryConnection, systemCode, regex);
        DataSourceMetaDataProvidor.setProvidor(systemCode, DataSourceMetaDataProvidor.RDF);
        return builder.asDataSource();
    }

    private void readCodeMapper(RepositoryConnection repositoryConnection, String systemCode, Pattern regex) throws RepositoryException, BridgeDBException {
        RepositoryResult statements = repositoryConnection.getStatements(null, BridgeDBConstants.SYSTEM_CODE_URI, (Value)new LiteralImpl(systemCode), true, new Resource[0]);
        Resource codeMapperReseource = null;
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Resource subject = statement.getSubject();
            String xrefPrefix = BridgeDBRdfHandler.getPossibleSingletonString(repositoryConnection, subject, BridgeDBConstants.XREF_PREFIX_URI);
            if (xrefPrefix == null) continue;
            if (regex != null) {
                if (regex.pattern().startsWith(xrefPrefix)) {
                    regex = Pattern.compile(regex.pattern().substring(xrefPrefix.length()));
                } else if (regex.pattern().startsWith("^" + xrefPrefix)) {
                    regex = Pattern.compile("^" + regex.pattern().substring(xrefPrefix.length() + 1));
                }
            }
            codeMapperReseource = subject;
            RdfBasedCodeMapper.addXrefPrefix(systemCode, xrefPrefix);
            this.readUriPatterns(repositoryConnection, codeMapperReseource, systemCode, UriPatternType.codeMapperPattern);
        }
    }

    private void readUriPatterns(RepositoryConnection repositoryConnection, Resource subject, String sysCode, UriPatternType patternType) throws BridgeDBException, RepositoryException {
        RepositoryResult statements = repositoryConnection.getStatements(subject, BridgeDBConstants.HAS_URI_PATTERN_URI, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Value uriValue = statement.getObject();
            UriPattern uriPattern = this.getUriPattern(repositoryConnection, (Resource)uriValue, sysCode, patternType);
        }
    }

    private UriPattern getUriPattern(RepositoryConnection repositoryConnection, Resource uriPatternResource, String code, UriPatternType patternType) throws BridgeDBException, RepositoryException {
        UriPattern result = this.uriPatternRegister.get(uriPatternResource);
        if (result == null) {
            result = UriPattern.readUriPattern(repositoryConnection, uriPatternResource, code, patternType);
            this.uriPatternRegister.put(uriPatternResource, result);
        } else {
            result.getSysCodes().add(code);
        }
        return result;
    }

    private void readAllUriPatterns(RepositoryConnection repositoryConnection) throws RepositoryException, BridgeDBException {
        RepositoryResult statements = repositoryConnection.getStatements(null, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.URI_PATTERN_URI, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            Resource uriPatternResource = statement.getSubject();
            UriPattern uriPattern = this.uriPatternRegister.get(uriPatternResource);
            if (uriPattern != null) continue;
            throw new BridgeDBException("Found an unused  " + BridgeDBConstants.URI_PATTERN_URI + " " + uriPatternResource);
        }
    }

    public static void parseRdfFile(File file) throws BridgeDBException {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            BridgeDBRdfHandler.parseRdfInputStream(inputStream);
        }
        catch (IOException ex) {
            throw new BridgeDBException("Error accessing file " + file.getAbsolutePath(), (Throwable)ex);
        }
    }

    public static void parseRdfInputStream(InputStream stream) throws BridgeDBException {
        BridgeDBRdfHandler handler = new BridgeDBRdfHandler();
        handler.doParseRdfInputStream(stream);
        UriPattern.checkRegexPatterns();
    }

    public static void main(String[] args) throws RepositoryException, BridgeDBException, IOException, RDFParseException, RDFHandlerException {
        ConfigReader.logToConsole();
        File file1 = new File("C:\\OpenPhacts\\BridgeDb\\org.bridgedb.rdf\\resources\\DataSource.ttl");
        BridgeDBRdfHandler.parseRdfFile(file1);
    }

    public static void init() throws BridgeDBException {
        if (initialized) {
            return;
        }
        InputStream stream = ConfigReader.getInputStream((String)CONFIG_FILE_NAME);
        BridgeDBRdfHandler.parseRdfInputStream(stream);
        initialized = true;
        Reporter.println((String)"BridgeDBRdfHandler initialized");
    }

    public static void writeRdfToFile(File file) throws BridgeDBException {
        TreeSet<DataSource> sortedDataSources = new TreeSet<DataSource>((Comparator<DataSource>)new DataSourceComparator());
        sortedDataSources.addAll(DataSource.getDataSources());
        BridgeDBRdfHandler.writeRdfToFile(file, sortedDataSources);
    }

    public static void writeRdfToFile(File file, SortedSet<DataSource> dataSources) throws BridgeDBException {
        Reporter.println((String)("Writing DataSource RDF to " + file.getAbsolutePath()));
        SailRepository repository = null;
        RepositoryConnection repositoryConnection = null;
        try {
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            for (DataSource dataSource : dataSources) {
                BridgeDBRdfHandler.writeDataSource(repositoryConnection, dataSource);
            }
            OrganismRdf.addAll(repositoryConnection);
            UriPattern.addAll(repositoryConnection);
            BridgeDBRdfHandler.writeRDF(repositoryConnection, file);
        }
        catch (Exception ex) {
            try {
                throw new BridgeDBException("Error writing RDF to file:" + ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                BridgeDBRdfHandler.shutDown(repository, repositoryConnection);
                throw throwable;
            }
        }
        BridgeDBRdfHandler.shutDown((Repository)repository, repositoryConnection);
    }

    private static void writeDataSource(RepositoryConnection repositoryConnection, DataSource dataSource) throws RepositoryException, BridgeDBException {
        SortedSet<UriPattern> sortedPatterns;
        Pattern pattern;
        String identifersOrgSimple;
        UriPattern identifersOrgSimplePattern;
        Resource id = BridgeDBRdfHandler.asResource(dataSource);
        repositoryConnection.add(id, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.DATA_SOURCE_URI, new Resource[0]);
        if (dataSource.getFullName() != null) {
            repositoryConnection.add(id, BridgeDBConstants.FULL_NAME_URI, (Value)new LiteralImpl(dataSource.getFullName()), new Resource[0]);
        }
        if (dataSource.getSystemCode() != null && !dataSource.getSystemCode().trim().isEmpty()) {
            repositoryConnection.add(id, BridgeDBConstants.SYSTEM_CODE_URI, (Value)new LiteralImpl(dataSource.getSystemCode()), new Resource[0]);
        }
        if (dataSource.getMainUrl() != null) {
            repositoryConnection.add(id, BridgeDBConstants.MAIN_URL_URI, (Value)new LiteralImpl(dataSource.getMainUrl()), new Resource[0]);
        }
        if (dataSource.getExample() != null && dataSource.getExample().getId() != null) {
            repositoryConnection.add(id, BridgeDBConstants.ID_EXAMPLE_URI, (Value)new LiteralImpl(dataSource.getExample().getId()), new Resource[0]);
        }
        if (dataSource.isPrimary()) {
            repositoryConnection.add(id, BridgeDBConstants.PRIMARY_URI, (Value)BooleanLiteralImpl.TRUE, new Resource[0]);
        } else {
            repositoryConnection.add(id, BridgeDBConstants.PRIMARY_URI, (Value)BooleanLiteralImpl.FALSE, new Resource[0]);
        }
        if (dataSource.getType() != null) {
            repositoryConnection.add(id, BridgeDBConstants.TYPE_URI, (Value)new LiteralImpl(dataSource.getType()), new Resource[0]);
        }
        Pattern regex = (Pattern)DataSourcePatterns.getPatterns().get(dataSource);
        String url = dataSource.getKnownUrl("$id");
        UriPattern urlPattern = UriPattern.byPattern(url);
        if (urlPattern != null) {
            repositoryConnection.add(id, BridgeDBConstants.HAS_PRIMARY_URI_PATTERN_URI, (Value)urlPattern.getResourceId(), new Resource[0]);
        }
        if ((identifersOrgSimplePattern = UriPattern.byPattern(identifersOrgSimple = dataSource.getIdentifiersOrgUri("$id"))) != null) {
            repositoryConnection.add(id, BridgeDBConstants.HAS_IDENTIFERS_ORG_PATTERN_URI, (Value)identifersOrgSimplePattern.getResourceId(), new Resource[0]);
            String identifersOrgInfo = identifersOrgSimple.replace("identifiers.org", "info.identifiers.org");
            UriPattern identifersOrgInfoPattern = UriPattern.byPattern(identifersOrgInfo);
            if (identifersOrgInfoPattern != null) {
                repositoryConnection.add(id, BridgeDBConstants.HAS_IDENTIFERS_ORG_INFO_PATTERN_URI, (Value)identifersOrgInfoPattern.getResourceId(), new Resource[0]);
            }
        }
        if (dataSource.getOrganism() != null) {
            Organism organism = (Organism)dataSource.getOrganism();
            repositoryConnection.add(id, BridgeDBConstants.ABOUT_ORGANISM_URI, (Value)OrganismRdf.getResourceId(organism), new Resource[0]);
        }
        if ((pattern = (Pattern)DataSourcePatterns.getPatterns().get(dataSource)) != null && !pattern.toString().isEmpty()) {
            LiteralImpl patternValue = new LiteralImpl(pattern.toString());
            repositoryConnection.add(id, BridgeDBConstants.HAS_REGEX_PATTERN_URI, (Value)patternValue, new Resource[0]);
        }
        if (dataSource.getAlternative() != null) {
            repositoryConnection.add(id, DCTermsConstants.ALTERNATIVE_URI, (Value)new LiteralImpl(dataSource.getAlternative()), new Resource[0]);
        }
        if (dataSource.getDescription() != null) {
            repositoryConnection.add(id, DCatConstants.DESCRIPTION_URI, (Value)new LiteralImpl(dataSource.getDescription()), new Resource[0]);
        }
        if ((sortedPatterns = UriPattern.byCodeAndType(dataSource.getSystemCode(), UriPatternType.dataSourceUriPattern)) != null) {
            for (UriPattern uriPattern : sortedPatterns) {
                repositoryConnection.add(id, BridgeDBConstants.HAS_URI_PATTERN_URI, (Value)uriPattern.getResourceId(), new Resource[0]);
            }
        }
        BridgeDBRdfHandler.writeCodeMapper(repositoryConnection, dataSource);
    }

    private static void writeCodeMapper(RepositoryConnection repositoryConnection, DataSource dataSource) throws RepositoryException {
        String xrefPrefix = RdfBasedCodeMapper.getXrefPrefix(dataSource.getSystemCode());
        if (xrefPrefix == null) {
            return;
        }
        Resource id = BridgeDBRdfHandler.asCodeMapperResource(dataSource);
        repositoryConnection.add(id, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.CODE_MAPPER_URI, new Resource[0]);
        repositoryConnection.add(id, BridgeDBConstants.SYSTEM_CODE_URI, (Value)new LiteralImpl(dataSource.getSystemCode()), new Resource[0]);
        LiteralImpl prefixValue = new LiteralImpl(xrefPrefix);
        repositoryConnection.add(id, BridgeDBConstants.XREF_PREFIX_URI, (Value)prefixValue, new Resource[0]);
        SortedSet<UriPattern> sortedPatterns = UriPattern.byCodeAndType(dataSource.getSystemCode(), UriPatternType.codeMapperPattern);
        if (sortedPatterns != null) {
            for (UriPattern pattern : sortedPatterns) {
                repositoryConnection.add(id, BridgeDBConstants.HAS_URI_PATTERN_URI, (Value)pattern.getResourceId(), new Resource[0]);
            }
        }
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, File file) throws IOException, RDFHandlerException, RepositoryException {
        FileWriter writer = new FileWriter(file);
        TurtleWriter turtleWriter = new TurtleWriter((Writer)writer);
        BridgeDBRdfHandler.writeRDF(repositoryConnection, (RDFWriter)turtleWriter);
        ((Writer)writer).close();
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, RDFWriter rdfWriter) throws IOException, RDFHandlerException, RepositoryException {
        rdfWriter.handleNamespace("bdb", "http://vocabularies.bridgedb.org/ops#");
        rdfWriter.handleNamespace("dcat", "http://www.w3.org/ns/dcat#");
        rdfWriter.handleNamespace("dcterms", "http://purl.org/dc/terms/");
        rdfWriter.handleNamespace("", DEFAULT_BASE_URI);
        rdfWriter.startRDF();
        RepositoryResult statements = repositoryConnection.getStatements(null, null, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            rdfWriter.handleStatement(statement);
        }
        rdfWriter.endRDF();
    }

    private static RDFFormat getFormat(File file) {
        RDFParserRegistry reg;
        FileFormat fileFormat;
        String fileName = file.getName();
        if (fileName.endsWith(".n3")) {
            fileName = "try.ttl";
        }
        if ((fileFormat = (reg = RDFParserRegistry.getInstance()).getFileFormatForFileName(fileName)) == null || !(fileFormat instanceof RDFFormat)) {
            logger.warn((Object)("OpenRDF does not know the RDF Format for " + fileName));
            logger.warn((Object)("Using the default format " + DEFAULT_FILE_FORMAT));
            return DEFAULT_FILE_FORMAT;
        }
        return (RDFFormat)fileFormat;
    }

    protected static Resource asResource(DataSource dataSource) {
        if (dataSource.getFullName() == null) {
            return new URIImpl("http://vocabularies.bridgedb.org/ops#DataSource_bysysCode_" + BridgeDBRdfHandler.scrub(dataSource.getSystemCode()));
        }
        return new URIImpl("http://vocabularies.bridgedb.org/ops#DataSource_" + BridgeDBRdfHandler.scrub(dataSource.getFullName()));
    }

    protected static Resource asCodeMapperResource(DataSource dataSource) {
        if (dataSource.getFullName() == null) {
            return new URIImpl("http://vocabularies.bridgedb.org/ops#CodeMapper_bysysCode_" + BridgeDBRdfHandler.scrub(dataSource.getSystemCode()));
        }
        return new URIImpl("http://vocabularies.bridgedb.org/ops#CodeMapper_" + BridgeDBRdfHandler.scrub(dataSource.getFullName()));
    }
}

