/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf.create;

import info.aduna.lang.FileFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class FormatConvertor {
    public static String DEFAULT_BASE_URI = "http://no/BaseURI/Set/";

    private static RDFFormat getFormat(String fileName) throws BridgeDBException {
        RDFParserRegistry reg;
        FileFormat fileFormat;
        if (fileName.endsWith(".n3")) {
            fileName = "try.ttl";
        }
        if ((fileFormat = (reg = RDFParserRegistry.getInstance()).getFileFormatForFileName(fileName)) == null || !(fileFormat instanceof RDFFormat)) {
            throw new BridgeDBException("failed");
        }
        return (RDFFormat)fileFormat;
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, File file) throws IOException, RDFHandlerException, RepositoryException {
        FileWriter writer = new FileWriter(file);
        TurtleWriter turtleWriter = new TurtleWriter((Writer)writer);
        FormatConvertor.writeRDF(repositoryConnection, (RDFWriter)turtleWriter);
        ((Writer)writer).close();
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, RDFWriter rdfWriter) throws IOException, RDFHandlerException, RepositoryException {
        rdfWriter.handleNamespace("bdb", "http://vocabularies.bridgedb.org/ops#");
        rdfWriter.handleNamespace("", DEFAULT_BASE_URI);
        rdfWriter.startRDF();
        RepositoryResult statements = repositoryConnection.getStatements(null, null, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            rdfWriter.handleStatement(statement);
        }
        rdfWriter.endRDF();
    }

    public static void convert(File inputFile, File outputFile) throws Exception {
        Reporter.println((String)("Parsing " + inputFile.getAbsolutePath()));
        SailRepository repository = null;
        try (RepositoryConnection repositoryConnection = null;){
            repository = new SailRepository((Sail)new MemoryStore());
            repository.initialize();
            repositoryConnection = repository.getConnection();
            repositoryConnection.add(inputFile, DEFAULT_BASE_URI, FormatConvertor.getFormat(inputFile.getName()), new Resource[0]);
            FormatConvertor.writeRDF(repositoryConnection, outputFile);
        }
    }

    public static void main(String[] args) throws Exception {
        FormatConvertor.convert(new File("C:/Temp/biomodels_void-dcat.rdf"), new File("C:/Temp/biomodels_void-dcat.ttl"));
        FormatConvertor.convert(new File("C:/Temp/biomodels_void-ops.rdf"), new File("C:/Temp/biomodels_void-ops.ttl"));
        FormatConvertor.convert(new File("C:/Temp/example_void-id.org.rdf"), new File("C:/Temp/example_void-id.org.ttl"));
    }
}

