/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.bio.DataSourceTxt;
import org.bridgedb.rdf.BridgeDBRdfHandler;
import org.bridgedb.rdf.DataSourceMetaDataProvidor;
import org.bridgedb.rdf.RdfBase;
import org.bridgedb.rdf.UriPatternType;
import org.bridgedb.rdf.constants.BridgeDBConstants;
import org.bridgedb.rdf.constants.RdfConstants;
import org.bridgedb.rdf.identifiers.org.IdentifersOrgReader;
import org.bridgedb.utils.BridgeDBException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class UriPattern
extends RdfBase
implements Comparable<UriPattern> {
    private final String prefix;
    private final String postfix;
    private UriPatternType patternType;
    private final Set<String> sysCodes;
    private static HashMap<String, UriPattern> byPattern = new HashMap();
    private static HashMap<String, Set<UriPattern>> byCode = new HashMap();
    static boolean initialized = false;
    private static HashSet<IRI> expectedPredicates = new HashSet<IRI>(Arrays.asList(BridgeDBConstants.HAS_POSTFIX_URI, BridgeDBConstants.HAS_PREFIX_URI, RdfConstants.TYPE_URI, BridgeDBConstants.HAS_DATA_SOURCE, BridgeDBConstants.IS_URI_PATTERN_OF));

    private UriPattern(String pattern, UriPatternType patternType) throws BridgeDBException {
        int pos = pattern.indexOf("$id");
        if (pos == -1) {
            throw new BridgeDBException("Pattern " + pattern + " does not have $id in it and is not known.");
        }
        this.prefix = pattern.substring(0, pos);
        this.postfix = pattern.substring(pos + 3);
        byPattern.put(pattern, this);
        this.patternType = patternType;
        this.sysCodes = new HashSet<String>();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPostfix() {
        return this.postfix;
    }

    public boolean hasPostfix() {
        return !this.postfix.isEmpty();
    }

    public static void refreshUriPatterns() throws BridgeDBException {
        if (initialized) {
            return;
        }
        DataSourceTxt.init();
        DataSourceMetaDataProvidor.assumeUnknownsAreBio();
        BridgeDBRdfHandler.init();
        IdentifersOrgReader.init();
        UriPattern.registerUriPatterns();
        initialized = true;
    }

    public static void registerUriPatterns() throws BridgeDBException {
        for (DataSource dataSource : DataSource.getDataSources()) {
            String identifersOrgUrl;
            String url = dataSource.getKnownUrl("$id");
            if (url != null) {
                UriPattern.register(url, dataSource.getSystemCode(), UriPatternType.mainUrlPattern);
            }
            if ((identifersOrgUrl = dataSource.getIdentifiersOrgUri("$id")) == null) continue;
            UriPattern.register(identifersOrgUrl, dataSource.getSystemCode(), UriPatternType.identifiersOrgPatternSimple);
            String identifersOrgInfoUrl = identifersOrgUrl.replace("identifiers.org", "info.identifiers.org");
            UriPattern.register(identifersOrgInfoUrl, dataSource.getSystemCode(), UriPatternType.identifiersOrgPatternInfo);
        }
    }

    public static SortedSet<UriPattern> getUriPatterns() {
        return new TreeSet<UriPattern>(byPattern.values());
    }

    public static UriPattern register(String pattern, String sysCode, UriPatternType patternType) throws BridgeDBException {
        if (pattern == null || pattern.isEmpty()) {
            throw new BridgeDBException("Illegal empty or null uriPattern: " + pattern);
        }
        if (sysCode == null || sysCode.isEmpty()) {
            throw new BridgeDBException("Illegal empty or null sysCode: " + sysCode);
        }
        UriPattern result = byPattern.get(pattern);
        if (result == null) {
            result = new UriPattern(pattern, patternType);
        }
        result.registerSysCode(sysCode);
        if (result.patternType == patternType) {
            return result;
        }
        switch (patternType) {
            case mainUrlPattern: {
                if (result.patternType != UriPatternType.dataSourceUriPattern) break;
                if (result.sysCodes.size() == 1) {
                    result.patternType = UriPatternType.mainUrlPattern;
                }
                return result;
            }
            case dataSourceUriPattern: {
                if (result.patternType == UriPatternType.mainUrlPattern) {
                    if (result.sysCodes.size() > 1) {
                        result.patternType = UriPatternType.dataSourceUriPattern;
                    }
                    return result;
                }
            }
            default: {
                throw new BridgeDBException("UriPattern " + pattern + " already set to type " + (Object)((Object)result.patternType) + " so unable to set to " + (Object)((Object)patternType));
            }
        }
        return result;
    }

    private void registerSysCode(String sysCode) {
        for (String knownCode : this.sysCodes) {
            if (!knownCode.equals(sysCode)) continue;
            return;
        }
        this.sysCodes.add(sysCode);
        Set<UriPattern> patterns = byCode.get(sysCode);
        if (patterns == null) {
            patterns = new HashSet<UriPattern>();
        }
        patterns.add(this);
        byCode.put(sysCode, patterns);
    }

    public static UriPattern byPattern(String pattern) throws BridgeDBException {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        if (!pattern.contains("$id")) {
            pattern = pattern + "$id";
        }
        return byPattern.get(pattern);
    }

    public static UriPattern existingByPattern(String pattern) throws BridgeDBException {
        UriPattern result = UriPattern.byPattern(pattern);
        if (result == null) {
            throw new BridgeDBException("No UriPattern known for: " + pattern);
        }
        return result;
    }

    public static UriPattern existingByPrefixAndPostfix(String prefix, String postfix) throws BridgeDBException {
        if (postfix == null) {
            return UriPattern.existingByPattern(prefix + "$id");
        }
        return UriPattern.existingByPattern(prefix + "$id" + postfix);
    }

    public final IRI getResourceId() {
        return SimpleValueFactory.getInstance().createIRI(this.getUriPattern());
    }

    public String getUriPattern() {
        if (this.postfix == null) {
            return this.prefix + "$id";
        }
        return this.prefix + "$id" + this.postfix;
    }

    public static void addAll(RepositoryConnection repositoryConnection) throws IOException, RepositoryException, BridgeDBException {
        for (UriPattern pattern : UriPattern.getUriPatterns()) {
            pattern.add(repositoryConnection);
        }
    }

    public void add(RepositoryConnection repositoryConnection) throws RepositoryException {
        IRI id = this.getResourceId();
        repositoryConnection.add((Resource)id, RdfConstants.TYPE_URI, (Value)BridgeDBConstants.URI_PATTERN_URI, new Resource[0]);
        repositoryConnection.add((Resource)id, BridgeDBConstants.HAS_PREFIX_URI, (Value)SimpleValueFactory.getInstance().createLiteral(this.prefix), new Resource[0]);
        if (!this.postfix.isEmpty()) {
            repositoryConnection.add((Resource)id, BridgeDBConstants.HAS_POSTFIX_URI, (Value)SimpleValueFactory.getInstance().createLiteral(this.postfix), new Resource[0]);
        }
    }

    public static UriPattern readUriPattern(RepositoryConnection repositoryConnection, Resource uriPatternId, String code, UriPatternType patternType) throws BridgeDBException, RepositoryException {
        UriPattern pattern;
        String prefix = UriPattern.getPossibleSingletonString(repositoryConnection, uriPatternId, BridgeDBConstants.HAS_PREFIX_URI);
        if (prefix == null) {
            String uriPattern = uriPatternId.stringValue();
            pattern = UriPattern.register(uriPattern, code, patternType);
        } else {
            String postfix = UriPattern.getPossibleSingletonString(repositoryConnection, uriPatternId, BridgeDBConstants.HAS_POSTFIX_URI);
            pattern = postfix == null ? UriPattern.register(prefix + "$id", code, patternType) : UriPattern.register(prefix + "$id" + postfix, code, patternType);
        }
        return pattern;
    }

    public String toString() {
        return this.getUriPattern();
    }

    @Override
    public int compareTo(UriPattern other) {
        String thisString = this.getResourceId().stringValue().toLowerCase();
        thisString = thisString.replaceFirst("https://", "http://");
        String otherString = other.getResourceId().stringValue().toLowerCase();
        otherString = otherString.replaceFirst("https://", "http://");
        return thisString.compareTo(otherString);
    }

    public String getUri(String id) {
        return this.prefix + id + this.postfix;
    }

    public String getIdFromUri(String uri) throws BridgeDBException {
        if (!uri.startsWith(this.prefix)) {
            throw new BridgeDBException("Uri " + uri + " does not match UriPattern " + this);
        }
        if (!uri.endsWith(this.postfix)) {
            throw new BridgeDBException("Uri " + uri + " does not match UriPattern " + this);
        }
        return uri.substring(this.prefix.length(), uri.length() - this.postfix.length());
    }

    public static SortedSet<UriPattern> byCodeAndType(String code, UriPatternType patternType) {
        TreeSet<UriPattern> results = new TreeSet<UriPattern>();
        Set<UriPattern> possibles = byCode.get(code);
        if (possibles != null) {
            for (UriPattern possible : possibles) {
                if (possible.patternType != patternType) continue;
                results.add(possible);
            }
        }
        return results;
    }

    public static Set<UriPattern> byCode(String code) {
        Set<UriPattern> possibles = byCode.get(code);
        if (possibles == null) {
            possibles = new HashSet<UriPattern>();
        }
        return possibles;
    }

    public UriPatternType getType() {
        return this.patternType;
    }

    public Set<String> getSysCodes() {
        return this.sysCodes;
    }

    public static void checkRegexPatterns() throws BridgeDBException {
        for (UriPattern uriPattern : byPattern.values()) {
            if (uriPattern.sysCodes.size() <= 1) continue;
            HashSet<String> patterns = new HashSet<String>();
            for (String sysCode : uriPattern.sysCodes) {
                DataSource dataSource = DataSource.getExistingBySystemCode((String)sysCode);
                Pattern regex = (Pattern)DataSourcePatterns.getPatterns().get(dataSource);
                if (regex == null || regex.pattern().isEmpty()) {
                    throw new BridgeDBException("UriPattern " + uriPattern + " is registered to " + uriPattern.sysCodes + " but DataSource " + dataSource + " has regex pattern " + regex);
                }
                if (patterns.contains(regex.pattern())) {
                    throw new BridgeDBException("UriPattern " + uriPattern + " is registered to " + uriPattern.sysCodes + " but at least two have the regex pattern " + regex);
                }
                patterns.add(regex.pattern());
            }
        }
    }
}

