/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdf.create;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.Reporter;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.turtle.TurtleWriter;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.memory.MemoryStore;

public class FormatConvertor {
    public static String DEFAULT_BASE_URI = "http://no/BaseURI/Set/";

    private static RDFFormat getFormat(String fileName) throws BridgeDBException {
        RDFParserRegistry reg;
        Optional fileFormat;
        if (fileName.endsWith(".n3")) {
            fileName = "try.ttl";
        }
        if ((fileFormat = (reg = RDFParserRegistry.getInstance()).getFileFormatForFileName(fileName)).get() == null) {
            throw new BridgeDBException("failed");
        }
        return (RDFFormat)fileFormat.get();
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, File file) throws IOException, RDFHandlerException, RepositoryException {
        FileWriter writer = new FileWriter(file);
        TurtleWriter turtleWriter = new TurtleWriter((Writer)writer);
        FormatConvertor.writeRDF(repositoryConnection, (RDFWriter)turtleWriter);
        ((Writer)writer).close();
    }

    private static void writeRDF(RepositoryConnection repositoryConnection, RDFWriter rdfWriter) throws IOException, RDFHandlerException, RepositoryException {
        rdfWriter.handleNamespace("bdb", "http://vocabularies.bridgedb.org/ops#");
        rdfWriter.handleNamespace("", DEFAULT_BASE_URI);
        rdfWriter.startRDF();
        RepositoryResult statements = repositoryConnection.getStatements(null, null, null, true, new Resource[0]);
        while (statements.hasNext()) {
            Statement statement = (Statement)statements.next();
            rdfWriter.handleStatement(statement);
        }
        rdfWriter.endRDF();
    }

    public static void convert(File inputFile, File outputFile) throws Exception {
        Reporter.println((String)("Parsing " + inputFile.getAbsolutePath()));
        SailRepository repository = null;
        try (RepositoryConnection repositoryConnection = null;){
            repository = new SailRepository((Sail)new MemoryStore());
            repository.init();
            repositoryConnection = repository.getConnection();
            repositoryConnection.add(inputFile, DEFAULT_BASE_URI, FormatConvertor.getFormat(inputFile.getName()), new Resource[0]);
            FormatConvertor.writeRDF(repositoryConnection, outputFile);
        }
    }

    public static void main(String[] args) throws Exception {
        FormatConvertor.convert(new File("C:/Temp/biomodels_void-dcat.rdf"), new File("C:/Temp/biomodels_void-dcat.ttl"));
        FormatConvertor.convert(new File("C:/Temp/biomodels_void-ops.rdf"), new File("C:/Temp/biomodels_void-ops.ttl"));
        FormatConvertor.convert(new File("C:/Temp/example_void-id.org.rdf"), new File("C:/Temp/example_void-id.org.ttl"));
    }
}

