/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.bridgedb.AttributeMapper;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.server.Server;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class Test {
    private IDMapper mapper;
    private Server server;
    private boolean configExists;

    @Before
    public void setUp() throws Exception {
        File f = new File("gdb.config");
        this.configExists = f.exists();
        if (this.configExists) {
            if (this.server == null) {
                this.server = new Server();
                this.server.run(8183, null, false);
            }
            if (this.mapper == null) {
                Class.forName("org.bridgedb.webservice.bridgerest.BridgeRest");
                this.mapper = BridgeDb.connect((String)"idmapper-bridgerest:http://localhost:8183/Human");
            }
        } else {
            System.err.println("Skipping server tests. No gdb.config found.");
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public IDMapper getLocalService() {
        return this.mapper;
    }

    @org.junit.Test
    public void testLocalMapID() throws IDMapperException, ClassNotFoundException {
        if (this.configExists) {
            IDMapper mapper = this.getLocalService();
            Xref insr = new Xref("3643", BioDataSource.ENTREZ_GENE);
            Xref affy = new Xref("33162_at", BioDataSource.AFFY);
            Set result = mapper.mapID(insr, new DataSource[0]);
            Assert.assertTrue((boolean)result.contains(affy));
            Assert.assertTrue((boolean)mapper.xrefExists(insr));
        }
    }

    @org.junit.Test
    public void testLocalCapabilities() throws IDMapperException, ClassNotFoundException {
        if (this.configExists) {
            IDMapper mapper = this.getLocalService();
            IDMapperCapabilities cap = mapper.getCapabilities();
            Set supported = cap.getSupportedSrcDataSources();
            Assert.assertTrue((boolean)supported.contains(DataSource.getBySystemCode((String)"L")));
            String val = cap.getProperty("SCHEMAVERSION");
            Assert.assertNotNull((Object)val);
            Set srcDs = cap.getSupportedSrcDataSources();
            Assert.assertTrue((srcDs.size() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)cap.isFreeSearchSupported());
            Assert.assertTrue((boolean)cap.isMappingSupported(BioDataSource.UNIPROT, BioDataSource.ENTREZ_GENE));
            Assert.assertFalse((boolean)cap.isMappingSupported(DataSource.getBySystemCode((String)"??"), DataSource.getBySystemCode((String)"!!")));
        }
    }

    @org.junit.Test
    public void testLocalSearch() throws IDMapperException, ClassNotFoundException {
        if (this.configExists) {
            IDMapper mapper = this.getLocalService();
            Set result = mapper.freeSearch("1234", 100);
            System.out.println(result);
            Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        }
    }

    @org.junit.Test
    public void testLocalAttributes() throws ClassNotFoundException, IDMapperException {
        if (this.configExists) {
            AttributeMapper mapper = (AttributeMapper)this.getLocalService();
            Xref insr = new Xref("3643", BioDataSource.ENTREZ_GENE);
            Map attrMap = mapper.getAttributes(insr);
            Assert.assertNotNull(attrMap.get("Symbol"));
            Assert.assertTrue((((Set)attrMap.get("Symbol")).size() == 2 ? 1 : 0) != 0);
            Set attrValues = mapper.getAttributes(insr, "Symbol");
            Assert.assertTrue((attrValues.size() == 2 ? 1 : 0) != 0);
            Map xrefMap = mapper.freeAttributeSearch("INSR", "Symbol", 1);
            Assert.assertTrue((xrefMap.size() == 1 ? 1 : 0) != 0);
            xrefMap = mapper.freeAttributeSearch("INSR", "Symbol", 100);
            Assert.assertTrue((boolean)xrefMap.containsKey(insr));
            Assert.assertTrue((xrefMap.size() > 1 ? 1 : 0) != 0);
            Set attrs = mapper.getAttributeSet();
            Assert.assertTrue((attrs.size() > 0 ? 1 : 0) != 0);
        }
    }
}

