/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.util.Map;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class AttributeSearch
extends IDMapperResource {
    String searchStr;
    String attribute;
    int limit = 0;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            this.searchStr = this.urlDecode((String)this.getRequest().getAttributes().get("query"));
            this.attribute = this.urlDecode((String)this.getRequest().getAttributes().get("attrName"));
            String limitStr = (String)this.getRequest().getAttributes().get("limit");
            if (null != limitStr) {
                this.limit = new Integer(limitStr);
            }
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String search() {
        try {
            IDMapperStack mapper = this.getIDMappers();
            if (this.attribute == null) {
                this.attribute = "Symbol";
            }
            Map results = mapper.freeAttributeSearch(this.searchStr, this.attribute, this.limit);
            StringBuilder result = new StringBuilder();
            for (Xref x : results.keySet()) {
                result.append(x.getId());
                result.append("\t");
                result.append(x.getDataSource().getFullName());
                result.append("\t");
                result.append((String)results.get(x));
                result.append("\n");
            }
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }
}

