/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.server;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.server.IDMapperResource;
import org.restlet.data.Status;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;

public class BackPageText
extends IDMapperResource {
    Xref xref;
    DataSource targetDs;

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        try {
            System.out.println("Xrefs.doInit start");
            String id = this.urlDecode((String)this.getRequest().getAttributes().get("id"));
            String dsName = this.urlDecode((String)this.getRequest().getAttributes().get("system"));
            DataSource dataSource = this.parseDataSource(dsName);
            if (dataSource == null) {
                throw new IllegalArgumentException("Unknown datasource: " + dsName);
            }
            this.xref = new Xref(id, dataSource);
            String targetDsName = (String)this.getRequest().getAttributes().get("dataSource");
            this.targetDs = this.parseDataSource(targetDsName);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    @Get
    public String getBackPageText() {
        System.out.println("Xrefs.getBackPageText() start");
        try {
            IDMapperStack mapper = this.getIDMappers();
            Set bpInfoSym = mapper.getAttributes(this.xref, "Symbol");
            Set bpInfoDes = mapper.getAttributes(this.xref, "Description");
            Set bpInfoTyp = mapper.getAttributes(this.xref, "Type");
            Set bpInfoChr = mapper.getAttributes(this.xref, "Chromosome");
            Set bpInfoSyn = mapper.getAttributes(this.xref, "Synonyms");
            StringBuilder result = new StringBuilder();
            result.append("<html><body><table>");
            for (String x : bpInfoSym) {
                result.append("<tr><td>Symbol</td><td>" + x + "</td></tr>");
            }
            for (String x : bpInfoDes) {
                result.append("<tr><td>Description</td><td>" + x + "</td></tr>");
            }
            for (String x : bpInfoTyp) {
                result.append("<tr><td>Type</td><td>" + x + "</td></tr>");
            }
            for (String x : bpInfoChr) {
                result.append("<tr><td>Chromosome</td><td>" + x + "</td></tr>");
            }
            for (String x : bpInfoSyn) {
                result.append("<tr><td>Synonyms</td><td>" + x + "</td></tr>");
            }
            result.append("</table></body></html>");
            return result.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setStatus(Status.SERVER_ERROR_INTERNAL);
            return e.getMessage();
        }
    }
}

