/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.mapping.MappingListener;
import org.bridgedb.sql.SQLBase;
import org.bridgedb.sql.SqlFactory;
import org.bridgedb.utils.BridgeDBException;

public class SQLListener
extends SQLBase
implements MappingListener {
    public static final int SQL_COMPAT_VERSION = 28;
    protected static final int SYSCODE_LENGTH = 100;
    protected static final int FULLNAME_LENGTH = 100;
    private static final int MAINURL_LENGTH = 100;
    private static final int URLPATTERN_LENGTH = 400;
    protected static final int ID_LENGTH = 100;
    private static final int TYPE_LENGTH = 100;
    private static final int URNBASE_LENGTH = 100;
    private static final int KEY_LENGTH = 100;
    private static final int PROPERTY_LENGTH = 100;
    private static final int MAX_BLOCK_SIZE = 10000;
    protected static final int MAPPING_URI_LENGTH = 200;
    static final String INFO_TABLE_NAME = "info";
    static final String MAPPING_TABLE_NAME = "mapping";
    public static final String MAPPING_SET_TABLE_NAME = "mappingSet";
    static final String PROPERTIES_TABLE_NAME = "properties";
    public static final String ID_COLUMN_NAME = "id";
    static final String IS_PUBLIC_COLUMN_NAME = "isPublic";
    static final String KEY_COLUMN_NAME = "theKey";
    public static final String MAPPING_SET_ID_COLUMN_NAME = "mappingSetId";
    static final String MAPPING_SET_DOT_ID_COLUMN_NAME = "mappingSet.id";
    static final String PROPERTY_COLUMN_NAME = "property";
    static final String SCHEMA_VERSION_COLUMN_NAME = "schemaversion";
    protected static final String SOURCE_DATASOURCE_COLUMN_NAME = "sourceDataSource";
    static final String SOURCE_ID_COLUMN_NAME = "sourceId";
    static final String SYSCODE_COLUMN_NAME = "sysCode";
    static final String TARGET_ID_COLUMN_NAME = "targetId";
    protected static final String TARGET_DATASOURCE_COLUMN_NAME = "targetDataSource";
    static final String TYPE_COLUMN_NAME = "type";
    static final String URL_PATTERN_COLUMN_NAME = "urlPattern";
    static final String URN_BASE_COLUMN_NAME = "urnBase";
    static final String LAST_UDPATES = "LastUpdates";
    static final String FULL_NAME_PREFIX = "_";
    private final int blockSize;
    private int blockCount = 0;
    private int insertCount = 0;
    private int doubleCount = 0;
    private PreparedStatement insertQuery;
    protected final String autoIncrement = SqlFactory.getAutoIncrementCommand();
    private String registerMappingQuery = null;
    private static final Logger logger = Logger.getLogger(SQLListener.class);

    public SQLListener(boolean dropTables) throws BridgeDBException {
        if (dropTables) {
            this.dropSQLTables();
            this.createSQLTables();
            logger.info((Object)"Recreated all tables!");
        } else {
            this.checkVersion();
        }
        this.blockSize = SqlFactory.supportsMultipleInserts() ? 10000 : 1;
        this.blockCount = this.blockSize;
        this.insertCount = 0;
        this.doubleCount = 0;
    }

    @Override
    public int registerMappingSet(DataSource source, DataSource target, boolean symetric) throws BridgeDBException {
        int forwardId = this.registerMappingSet(source, target);
        if (symetric) {
            int n = this.registerMappingSet(target, source);
        }
        return forwardId;
    }

    protected final String getDataSourceKey(DataSource dataSource) {
        if (dataSource.getSystemCode() == null) {
            return FULL_NAME_PREFIX + dataSource.getFullName();
        }
        return dataSource.getSystemCode();
    }

    private final DataSource keyToDataSource(String key) {
        if (key.startsWith(FULL_NAME_PREFIX)) {
            String fullName = key.substring(FULL_NAME_PREFIX.length());
            return DataSource.getByFullName((String)fullName);
        }
        return DataSource.getBySystemCode((String)key);
    }

    private int registerMappingSet(DataSource source, DataSource target) throws BridgeDBException {
        int n;
        PreparedStatement statement = null;
        try {
            if (this.registerMappingQuery == null) {
                StringBuilder query = new StringBuilder("INSERT INTO ");
                query.append(MAPPING_SET_TABLE_NAME);
                query.append(" (");
                query.append(SOURCE_DATASOURCE_COLUMN_NAME);
                query.append(", ");
                query.append(TARGET_DATASOURCE_COLUMN_NAME);
                query.append(") VALUES ( ?, ?)");
                this.registerMappingQuery = query.toString();
            }
            statement = this.createPreparedStatement(this.registerMappingQuery);
            statement.setString(1, this.getDataSourceKey(source));
            statement.setString(2, this.getDataSourceKey(target));
            statement.executeUpdate();
            int autoinc = this.getAutoInc();
            logger.info((Object)("Registered new Mapping " + autoinc + " from " + this.getDataSourceKey(source) + " to " + this.getDataSourceKey(target)));
            n = autoinc;
        }
        catch (SQLException ex) {
            try {
                throw new BridgeDBException("Error registering mappingSet ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close(statement, null);
                throw throwable;
            }
        }
        this.close(statement, null);
        return n;
    }

    protected final int getAutoInc() throws BridgeDBException {
        Statement statement = this.createStatement();
        int autoinc = 0;
        String getId = "SELECT @@identity";
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(getId);
            if (!rs.next()) {
                throw new BridgeDBException("No result getting new indetity with " + getId);
            }
            autoinc = rs.getInt(1);
            int n = autoinc;
            return n;
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error getting new indetity with " + getId, (Throwable)ex);
        }
        finally {
            this.close(statement, rs);
        }
    }

    @Override
    public void closeInput() throws BridgeDBException {
        this.runInsert();
        try {
            if (this.insertQuery != null) {
                this.commitTransaction();
                this.insertQuery.close();
            }
        }
        catch (SQLException e) {
            throw new BridgeDBException("Error closing insert query", (Throwable)e);
        }
        Statement statement = this.createStatement();
        try {
            statement.execute("analyze table mapping");
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error analyze table mapping ", (Throwable)ex);
        }
        this.insertQuery = null;
        logger.debug((Object)"Finished processing linkset");
        if (this.possibleOpenConnection != null) {
            try {
                this.possibleOpenConnection.close();
            }
            catch (SQLException ex) {
                throw new BridgeDBException("Error closing connection ", (Throwable)ex);
            }
        }
        this.blockCount = this.blockSize;
        this.insertCount = 0;
        this.doubleCount = 0;
        this.updateLastUpdated();
        this.closeConnection();
        logger.debug((Object)"Closed input");
    }

    @Override
    public void insertLink(String sourceId, String targetId, int mappingSet, boolean symetric) throws BridgeDBException {
        this.insertLink(sourceId, targetId, mappingSet);
        if (symetric) {
            this.insertLink(targetId, sourceId, mappingSet + 1);
        }
    }

    private void insertLink(String sourceId, String targetId, int mappingSetId) throws BridgeDBException {
        if (this.insertQuery == null) {
            this.startTransaction();
            StringBuilder sql = new StringBuilder("INSERT INTO ");
            sql.append(MAPPING_TABLE_NAME);
            sql.append(" (");
            sql.append(SOURCE_ID_COLUMN_NAME);
            sql.append(", ");
            sql.append(TARGET_ID_COLUMN_NAME);
            sql.append(", ");
            sql.append(MAPPING_SET_ID_COLUMN_NAME);
            sql.append(") VALUES ");
            sql.append("(?,?,?)");
            this.insertQuery = this.createPreparedStatement(sql.toString());
        }
        if (this.blockCount >= this.blockSize) {
            this.runInsert();
        }
        ++this.blockCount;
        try {
            this.insertQuery.setString(1, sourceId);
            this.insertQuery.setString(2, targetId);
            this.insertQuery.setInt(3, mappingSetId);
            this.insertQuery.addBatch();
        }
        catch (SQLException e) {
            System.err.println(e);
            throw new BridgeDBException("Error inserting link ", (Throwable)e, String.format("%s %s %s", sourceId, targetId, mappingSetId));
        }
    }

    private void runInsert() throws BridgeDBException {
        if (this.insertQuery != null) {
            try {
                int[] changedPerInsert = this.insertQuery.executeBatch();
                this.blockCount = 0;
                for (int changed : changedPerInsert) {
                    this.insertCount += changed;
                    this.doubleCount += this.blockCount - changed;
                }
            }
            catch (SQLException ex) {
                System.err.println(ex);
                throw new BridgeDBException("Error inserting link ", (Throwable)ex, this.insertQuery.toString());
            }
        }
        this.blockCount = 0;
    }

    protected void dropSQLTables() throws BridgeDBException {
        this.dropTable(INFO_TABLE_NAME);
        this.dropTable(MAPPING_TABLE_NAME);
        this.dropTable(MAPPING_SET_TABLE_NAME);
        this.dropTable(PROPERTIES_TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable(String name) throws BridgeDBException {
        Statement statement = this.createStatement();
        try {
            statement.execute("DROP TABLE " + name);
            statement.close();
        }
        catch (SQLException e) {
            System.err.println("Unable to drop table " + name + " assuming it does not exist");
        }
        finally {
            this.close(statement, null);
        }
    }

    protected void createSQLTables() throws BridgeDBException {
        String query = "";
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.execute("CREATE TABLE                            info (    schemaversion INTEGER PRIMARY KEY\t)" + SqlFactory.engineSetting());
            statement.execute("INSERT INTO info VALUES ( 28)");
            query = "CREATE TABLE mapping( sourceId VARCHAR(100) NOT NULL,   targetId VARCHAR(100) NOT NULL,   mappingSetId INT, INDEX `setFind` (mappingSetId), INDEX `sourceFind` (sourceId), INDEX `sourceMappingSetFind` (mappingSetId, sourceId)  ) " + SqlFactory.engineSetting();
            statement.execute(query);
            statement.execute("CREATE TABLE      properties(   theKey      VARCHAR(100) NOT NULL,     property    VARCHAR(100) NOT NULL,     isPublic    SMALLINT  ) " + SqlFactory.engineSetting());
            statement.close();
        }
        catch (SQLException e) {
            throw new BridgeDBException("Error creating the tables using " + query, (Throwable)e);
        }
        finally {
            this.close(statement, null);
        }
        this.createMappingSetTable();
    }

    protected void createMappingSetTable() throws BridgeDBException {
        String query = "";
        Statement statement = null;
        try {
            statement = this.createStatement();
            query = "CREATE TABLE mappingSet (id INT " + this.autoIncrement + " PRIMARY KEY, " + SOURCE_DATASOURCE_COLUMN_NAME + " VARCHAR(" + 100 + ") NOT NULL, " + TARGET_DATASOURCE_COLUMN_NAME + " VARCHAR(" + 100 + ")  NOT NULL  ) " + SqlFactory.engineSetting();
            statement.execute(query);
            statement.close();
        }
        catch (SQLException e) {
            throw new BridgeDBException("Error creating the MappingSet table using " + query, (Throwable)e);
        }
        finally {
            this.close(statement, null);
        }
    }

    private void checkVersion() throws BridgeDBException {
        Statement statement = this.createStatement();
        ResultSet rs = null;
        int version = 0;
        try {
            rs = statement.executeQuery("SELECT schemaversion FROM info");
            if (rs.next()) {
                version = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error checking the version. ", (Throwable)ex);
        }
        finally {
            this.close(statement, rs);
        }
        if (version == 28) {
            return;
        }
        switch (version) {
            case 2: {
                throw new BridgeDBException("Please use the SimpleGdbFactory in the org.bridgedb.rdb package");
            }
            case 3: {
                throw new BridgeDBException("Please use the SimpleGdbFactory in the org.bridgedb.rdb package");
            }
        }
        throw new BridgeDBException("Unrecognized schema version '" + version + "', expected " + 28 + " Please make sure you have the latest version of this software and databases");
    }

    private String booleanIntoQuery(boolean bool) {
        if (bool) {
            return "1";
        }
        return "0";
    }

    private void updateLastUpdated() throws BridgeDBException {
        String date = new Date().toString();
        this.putProperty(LAST_UDPATES, date);
    }

    public void putProperty(String key, String value) throws BridgeDBException {
        String delete = "DELETE from properties where theKey = '" + key + "'";
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate(delete.toString());
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error Deleting property " + delete, (Throwable)ex);
        }
        String update = "INSERT INTO properties (theKey, property, isPublic ) VALUES ('" + key + "', '" + value + "' , 1)  ";
        try {
            statement.executeUpdate(update.toString());
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error inserting Property " + update, (Throwable)ex);
        }
        finally {
            this.close(statement, null);
        }
    }
}

