/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.impl.InternalUtils;
import org.bridgedb.pairs.CodeMapper;
import org.bridgedb.pairs.IdSysCodePair;
import org.bridgedb.sql.SQLListener;
import org.bridgedb.sql.SqlFactory;
import org.bridgedb.utils.BridgeDBException;

public class SQLIdMapper
extends SQLListener
implements IDMapper,
IDMapperCapabilities {
    private static final int FREESEARCH_CUTOFF = 100000;
    protected static final int DEFAULT_LIMIT = 1000;
    private final boolean useLimit = SqlFactory.supportsLimit();
    private final boolean useTop = SqlFactory.supportsTop();
    protected final CodeMapper codeMapper;
    private static final Logger logger = Logger.getLogger(SQLIdMapper.class);
    private boolean isConnected = true;

    public SQLIdMapper(boolean dropTables, CodeMapper codeMapper) throws BridgeDBException {
        super(dropTables);
        this.codeMapper = codeMapper;
    }

    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        return InternalUtils.mapMultiFromSingle((IDMapper)this, srcXrefs, (DataSource[])tgtDataSources);
    }

    public Set<Xref> mapID(Xref xref, DataSource ... tgtDataSources) throws BridgeDBException {
        IdSysCodePair ref = this.toIdSysCodePair(xref);
        if (ref == null) {
            logger.debug((Object)("mapId called with a badXref " + xref));
            return new HashSet<Xref>();
        }
        String[] tgtSysCodes = this.toCodes(tgtDataSources);
        Set<IdSysCodePair> pairs = this.mapID(ref, tgtSysCodes);
        return this.toXrefs(pairs);
    }

    private Set<IdSysCodePair> mapID(IdSysCodePair ref, String ... tgtSysCodes) throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("targetId");
        query.append(", ");
        query.append("targetDataSource");
        query.append(" FROM ");
        query.append("mapping");
        query.append(", ");
        query.append("mappingSet");
        this.appendMappingJoinMapping(query);
        this.appendSourceIdSysCodePair(query, ref);
        if (tgtSysCodes != null && tgtSysCodes.length > 0) {
            query.append(" AND ( ");
            query.append("targetDataSource");
            query.append(" = '");
            query.append(tgtSysCodes[0]);
            query.append("' ");
            for (int i = 1; i < tgtSysCodes.length; ++i) {
                query.append(" OR ");
                query.append("targetDataSource");
                query.append(" = '");
                query.append(tgtSysCodes[i]);
                query.append("'");
            }
            query.append(")");
        }
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
        Set<IdSysCodePair> results = this.resultSetToIdSysCodePairSet(rs);
        if (tgtSysCodes.length == 0) {
            results.add(ref);
        } else {
            for (String tgtSysCode : tgtSysCodes) {
                if (!ref.getSysCode().equals(tgtSysCode)) continue;
                results.add(ref);
            }
        }
        if (results.size() <= 1) {
            String targets = "";
            for (String tgtSysCode : tgtSysCodes) {
                targets = targets + tgtSysCode + ", ";
            }
            if (targets.isEmpty()) {
                targets = "all DataSources";
            }
            if (logger.isDebugEnabled()) {
                if (results.isEmpty()) {
                    logger.debug((Object)("Unable to map " + ref + " to any results for " + targets));
                } else {
                    logger.debug((Object)("Only able to map " + ref + " to itself for " + targets));
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mapped " + ref + " to " + results.size() + " results"));
        }
        this.close(statement, rs);
        return results;
    }

    public Set<Xref> mapID(Xref xref, DataSource tgtDataSource) throws BridgeDBException {
        IdSysCodePair ref = this.toIdSysCodePair(xref);
        if (ref == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("mapId called with a badXref " + xref));
            }
            return new HashSet<Xref>();
        }
        if (tgtDataSource == null) {
            throw new BridgeDBException("Target DataSource can not be null");
        }
        String tgtSysCode = this.toCode(tgtDataSource);
        Set<IdSysCodePair> pairs = this.mapID(ref, tgtSysCode);
        return this.toXrefs(pairs);
    }

    private Set<IdSysCodePair> mapID(IdSysCodePair ref, String tgtSysCode) throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("targetId");
        query.append(", ");
        query.append("targetDataSource");
        query.append(" FROM ");
        query.append("mapping");
        query.append(", ");
        query.append("mappingSet");
        this.appendMappingJoinMapping(query);
        this.appendSourceIdSysCodePair(query, ref);
        query.append(" AND ");
        query.append("targetDataSource");
        query.append(" = '");
        query.append(tgtSysCode);
        query.append("' ");
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
        Set<IdSysCodePair> pairs = this.resultSetToIdSysCodePairSet(rs);
        if (ref.getSysCode().equals(tgtSysCode)) {
            pairs.add(ref);
        }
        this.close(statement, rs);
        return pairs;
    }

    public boolean xrefExists(Xref xref) throws BridgeDBException {
        IdSysCodePair ref = this.toIdSysCodePair(xref);
        if (ref == null) {
            return false;
        }
        return this.IdSysCodePairExists(ref);
    }

    protected boolean IdSysCodePairExists(IdSysCodePair ref) throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        this.appendTopConditions(query, 0, 1);
        query.append("targetId");
        query.append(" FROM ");
        query.append("mapping");
        query.append(", ");
        query.append("mappingSet");
        query.append(" WHERE ");
        query.append("mappingSetId");
        query.append(" = ");
        query.append("mappingSet.id");
        this.appendSourceIdSysCodePair(query, ref);
        this.appendLimitConditions(query, 0, 1);
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
            boolean result = rs.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(ref + " exists = " + result));
            }
            this.close(statement, rs);
            return result;
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
    }

    public Set<Xref> freeSearch(String text, int limit) throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        this.appendTopConditions(query, 0, limit);
        query.append("sourceId");
        query.append(" as ");
        query.append("targetId");
        query.append(", ");
        query.append("sourceDataSource");
        query.append(" as ");
        query.append("targetDataSource");
        query.append(" FROM ");
        query.append("mapping");
        query.append(", ");
        query.append("mappingSet");
        query.append(" WHERE ");
        query.append("mappingSetId");
        query.append(" = ");
        query.append("mappingSet.id");
        query.append(" AND ");
        query.append("sourceId");
        query.append(" = '");
        query.append(text);
        query.append("' ");
        this.appendLimitConditions(query, 0, limit);
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
        Set<IdSysCodePair> pairs = this.resultSetToIdSysCodePairSet(rs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Freesearch for " + text + " gave " + pairs.size() + " results"));
        }
        this.close(statement, rs);
        return this.toXrefs(pairs);
    }

    public IDMapperCapabilities getCapabilities() {
        return this;
    }

    public void close() {
        this.isConnected = false;
        this.closeConnection();
    }

    public boolean isConnected() {
        if (this.isConnected) {
            try {
                this.sqlAccess.getConnection();
                return true;
            }
            catch (BridgeDBException ex) {
                return false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("isConnected() returned  " + this.isConnected));
        }
        return this.isConnected;
    }

    public boolean isFreeSearchSupported() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"isFreeSearchSupported() returned  true");
        }
        return true;
    }

    public Set<DataSource> getSupportedSrcDataSources() throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("sourceDataSource");
        query.append(" as ");
        query.append("sysCode");
        query.append(" FROM ");
        query.append("mappingSet");
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
        Set<DataSource> results = this.resultSetToDataSourceSet(rs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSupportedSrcDataSources() returned " + results.size() + " results"));
        }
        this.close(statement, rs);
        return results;
    }

    public Set<DataSource> getSupportedTgtDataSources() throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("targetDataSource");
        query.append(" as ");
        query.append("sysCode");
        query.append(" FROM ");
        query.append("mappingSet");
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
        Set<DataSource> results = this.resultSetToDataSourceSet(rs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSupportedTgtDataSources() returned " + results.size() + " results"));
        }
        this.close(statement, rs);
        return results;
    }

    public boolean isMappingSupported(DataSource src, DataSource tgt) throws BridgeDBException {
        StringBuilder query = new StringBuilder();
        query.append("SELECT ");
        query.append("id");
        query.append(" FROM ");
        query.append("mappingSet");
        query.append(" WHERE ");
        query.append("sourceDataSource");
        query.append(" = '");
        query.append(this.getDataSourceKey(src));
        query.append("' ");
        query.append(" AND ");
        query.append("targetDataSource");
        query.append(" = '");
        query.append(this.getDataSourceKey(tgt));
        query.append("' ");
        Statement statement = this.createStatement();
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(query.toString());
            boolean result = rs.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("isMappingSupported " + src + " to " + tgt + " is " + result));
            }
            this.close(statement, rs);
            return result;
        }
        catch (SQLException ex) {
            this.close(statement, rs);
            throw new BridgeDBException("Unable to run query. " + query, (Throwable)ex);
        }
    }

    public String getProperty(String key) {
        String query = "SELECT DISTINCT property FROM properties WHERE theKey = '" + key + "'";
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.createStatement();
            rs = statement.executeQuery(query);
            if (rs.next()) {
                String result = rs.getString("property");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("property " + key + " is " + result));
                }
                this.close(statement, rs);
                return result;
            }
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("No property " + key + " found! "));
            }
            this.close(statement, rs);
            return null;
        }
        catch (Exception ex) {
            this.close(statement, rs);
            return null;
        }
    }

    public Set<String> getKeys() {
        HashSet<String> results = new HashSet<String>();
        String query = "SELECT theKey FROM properties WHERE isPublic = 1";
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = this.createStatement();
            rs = statement.executeQuery(query);
            while (rs.next()) {
                results.add(rs.getString("theKey"));
            }
            if (logger.isDebugEnabled()) {
                logger.warn((Object)("getKeys() returned " + results.size() + " keys! "));
            }
            this.close(statement, rs);
            return results;
        }
        catch (Exception ex) {
            this.close(statement, rs);
            logger.error((Object)"Error getting keys ", (Throwable)ex);
            return null;
        }
    }

    protected final boolean badXref(Xref ref) {
        if (ref == null) {
            return true;
        }
        if (ref.getId() == null || ref.getId().isEmpty()) {
            return true;
        }
        return ref.getDataSource() == null;
    }

    protected final void appendSourceIdSysCodePair(StringBuilder query, IdSysCodePair ref) {
        query.append(" AND ");
        query.append("sourceId");
        query.append(" = '");
        query.append(ref.getId());
        query.append("' ");
        query.append(" AND ");
        query.append("sourceDataSource");
        query.append(" = '");
        query.append(ref.getSysCode());
        query.append("' ");
    }

    protected final void appendSourceXref(StringBuilder query, String id, String sysCode) {
        query.append(" AND ");
        query.append("sourceId");
        query.append(" = '");
        query.append(id);
        query.append("' ");
        query.append(" AND ");
        query.append("sourceDataSource");
        query.append(" = '");
        query.append(sysCode);
        query.append("' ");
    }

    final Set<IdSysCodePair> resultSetToIdSysCodePairSet(ResultSet rs) throws BridgeDBException {
        HashSet<IdSysCodePair> results = new HashSet<IdSysCodePair>();
        try {
            while (rs.next()) {
                String id = rs.getString("targetId");
                String sysCode = rs.getString("targetDataSource");
                IdSysCodePair pair = new IdSysCodePair(id, sysCode);
                results.add(pair);
            }
            return results;
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Unable to parse results.", (Throwable)ex);
        }
    }

    private Set<DataSource> resultSetToDataSourceSet(ResultSet rs) throws BridgeDBException {
        HashSet<DataSource> results = new HashSet<DataSource>();
        try {
            while (rs.next()) {
                String sysCode = rs.getString("sysCode");
                results.add(DataSource.getExistingBySystemCode((String)sysCode));
            }
            return results;
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Unable to parse results.", (Throwable)ex);
        }
    }

    protected void appendLimitConditions(StringBuilder query, Integer position, Integer limit) {
        if (this.useLimit) {
            if (position == null) {
                position = 0;
            }
            if (limit == null) {
                limit = 1000;
            }
            query.append(" LIMIT " + position + ", " + limit);
        }
    }

    protected void appendTopConditions(StringBuilder query, Integer position, Integer limit) {
        if (this.useTop) {
            if (position == null) {
                position = 0;
            }
            if (limit == null) {
                limit = 1000;
            }
            query.append("TOP " + position + ", " + limit + " ");
        }
    }

    protected final void appendMappingJoinMapping(StringBuilder query) {
        query.append(" WHERE ");
        query.append("mappingSetId");
        query.append(" = ");
        query.append("mappingSet.id");
    }

    protected final String[] toCodes(DataSource[] tgtDataSources) {
        if (tgtDataSources == null || tgtDataSources.length == 0) {
            return new String[0];
        }
        String[] results = new String[tgtDataSources.length];
        for (int i = 0; i < tgtDataSources.length; ++i) {
            results[i] = tgtDataSources[i].getSystemCode();
        }
        return results;
    }

    protected final IdSysCodePair toIdSysCodePair(Xref xref) throws BridgeDBException {
        if (xref == null || xref.getId() == null || xref.getDataSource() == null) {
            return null;
        }
        return this.codeMapper.toIdSysCodePair(xref);
    }

    protected final Set<Xref> toXrefs(Set<IdSysCodePair> pairs) throws BridgeDBException {
        HashSet<Xref> results = new HashSet<Xref>();
        for (IdSysCodePair pair : pairs) {
            results.add(this.codeMapper.toXref(pair));
        }
        return results;
    }

    protected final String toCode(DataSource tgtDataSource) {
        if (tgtDataSource == null) {
            return null;
        }
        return tgtDataSource.getSystemCode();
    }
}

