/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.bridgedb.sql.SQLAccess;
import org.bridgedb.sql.SqlFactory;
import org.bridgedb.utils.BridgeDBException;

public class SQLBase {
    private static final int SQL_TIMEOUT = 2;
    protected SQLAccess sqlAccess = SqlFactory.createTheSQLAccess();
    protected Connection possibleOpenConnection;
    private final boolean supportsIsValid = SqlFactory.supportsIsValid();
    private static final Logger logger = Logger.getLogger(SQLBase.class);

    private void checkConnection() throws BridgeDBException, SQLException {
        if (this.possibleOpenConnection == null) {
            this.possibleOpenConnection = this.sqlAccess.getConnection();
        } else if (this.possibleOpenConnection.isClosed()) {
            this.possibleOpenConnection = this.sqlAccess.getConnection();
        } else if (this.supportsIsValid && !this.possibleOpenConnection.isValid(2)) {
            this.possibleOpenConnection.close();
            this.possibleOpenConnection = this.sqlAccess.getConnection();
        }
    }

    public void closeConnection() {
        if (this.possibleOpenConnection != null) {
            try {
                this.possibleOpenConnection.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        logger.info((Object)"close() successful");
    }

    public final Statement createStatement() throws BridgeDBException {
        try {
            this.checkConnection();
            return this.possibleOpenConnection.createStatement();
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error creating a new statement ", (Throwable)ex);
        }
    }

    public final PreparedStatement createPreparedStatement(String sql) throws BridgeDBException {
        try {
            this.checkConnection();
            return this.possibleOpenConnection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error creating a new prepared statement " + sql, (Throwable)ex);
        }
    }

    public final void startTransaction() throws BridgeDBException {
        try {
            this.checkConnection();
            this.possibleOpenConnection.setAutoCommit(false);
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error starting transaction.", (Throwable)ex);
        }
    }

    public final void commitTransaction() throws BridgeDBException {
        try {
            this.possibleOpenConnection.commit();
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error commiting transaction.", (Throwable)ex);
        }
    }

    public final void rollbackTransaction() throws BridgeDBException {
        try {
            this.possibleOpenConnection.rollback();
        }
        catch (SQLException ex) {
            throw new BridgeDBException("Error rolling back transaction.", (Throwable)ex);
        }
    }

    public final String insertEscpaeCharacters(String original) {
        String result = original.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("'", "\\\\'");
        result = result.replaceAll("\"", "\\\\\"");
        return result;
    }

    protected final void close(Statement statement, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"Error closing resultSet", (Throwable)ex);
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                logger.error((Object)"Error closing statment", (Throwable)ex);
            }
        }
    }
}

