/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.bridgedb.sql.SQLAccess;
import org.bridgedb.utils.BridgeDBException;

public class MySQLAccess
implements SQLAccess {
    private String dbUrl;
    private String username;
    private String password;

    public MySQLAccess(String dbUrl, String username, String password) throws BridgeDBException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            if (dbUrl.equals("jdbc:mysql://localhost:3306/irs")) {
                throw new BridgeDBException("Saftey Error! jdbc:mysql://localhost:3306/irs is resevered for March 2012 version");
            }
            this.dbUrl = dbUrl;
            this.username = username;
            this.password = password;
        }
        catch (ClassNotFoundException ex) {
            String msg = "Problem loading in MySQL JDBC driver.";
            throw new BridgeDBException(msg, (Throwable)ex);
        }
    }

    @Override
    public Connection getConnection() throws BridgeDBException {
        try {
            Properties info = new Properties();
            info.put("user", this.username);
            info.put("password", this.password);
            info.put("protocol", "tcp");
            Connection conn = DriverManager.getConnection(this.dbUrl, info);
            return conn;
        }
        catch (SQLException ex) {
            System.err.println(ex);
            String msg = "Problem connecting to database.";
            throw new BridgeDBException("Problem connecting to database.", (Throwable)ex);
        }
    }
}

