/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.sql;

import org.apache.log4j.Logger;
import org.bridgedb.mysql.MySQLAccess;
import org.bridgedb.sql.SQLAccess;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.bridgedb.virtuoso.VirtuosoAccess;

public class SqlFactory
extends ConfigReader {
    public static final String SQL_PORT_PROPERTY = "SqlPort";
    public static final String SQL_USER_PROPERTY = "SqlUser";
    public static final String SQL_PASSWORD_PROPERTY = "SqlPassword";
    public static final String SQL_DATABASE_PROPERTY = "SqlDatabase";
    public static final String TEST_SQL_DATABASE_PROPERTY = "TestSqlDatabase";
    public static final String TEST_SQL_USER_PROPERTY = "TestSqlUser";
    public static final String TEST_SQL_PASSWORD_PROPERTY = "TestSqlPassword";
    public static final String MYSQL_ENGINE_PROPERTY = "mysql.engine";
    private static boolean useMySQL = true;
    static final Logger logger = Logger.getLogger(SqlFactory.class);

    public static SQLAccess createTheSQLAccess() throws BridgeDBException {
        SQLAccess sqlAccess;
        if (useMySQL) {
            if (useTest) {
                sqlAccess = new MySQLAccess(SqlFactory.sqlPort() + "/" + SqlFactory.sqlTestDatabase(), SqlFactory.testSqlUser(), SqlFactory.testSqlPassword());
                logger.info((Object)("Connecting to test MYSQL database " + SqlFactory.sqlTestDatabase()));
            } else {
                sqlAccess = new MySQLAccess(SqlFactory.sqlPort() + "/" + SqlFactory.sqlDatabase(), SqlFactory.sqlUser(), SqlFactory.sqlPassword());
                logger.info((Object)("Connecting to Live MYSQL database " + SqlFactory.sqlDatabase()));
            }
        } else {
            sqlAccess = new VirtuosoAccess();
            logger.info((Object)"Connecting to hardcoded Virtuoso database. Ignoring StoreType");
        }
        sqlAccess.getConnection();
        return sqlAccess;
    }

    public static SQLAccess createASQLAccess(String database) throws BridgeDBException {
        MySQLAccess sqlAccess = new MySQLAccess(SqlFactory.sqlPort() + "/" + database, SqlFactory.sqlUser(), SqlFactory.sqlPassword());
        return sqlAccess;
    }

    public static void setUseMySQL(boolean forceMySQL) {
        useMySQL = forceMySQL;
    }

    private static String sqlPort() throws BridgeDBException {
        String result = SqlFactory.getProperties().getProperty(SQL_PORT_PROPERTY);
        if (result != null) {
            return result.trim();
        }
        return "jdbc:mysql://localhost:3306";
    }

    private static String sqlPassword() throws BridgeDBException {
        String result = SqlFactory.getProperties().getProperty(SQL_PASSWORD_PROPERTY);
        if (result != null) {
            return result.trim();
        }
        return "ims";
    }

    private static String sqlUser() throws BridgeDBException {
        String result = SqlFactory.getProperties().getProperty(SQL_USER_PROPERTY);
        if (result != null) {
            return result.trim();
        }
        return "ims";
    }

    private static String sqlDatabase() throws BridgeDBException {
        String result = SqlFactory.getProperties().getProperty(SQL_DATABASE_PROPERTY);
        if (result != null) {
            return result.trim();
        }
        return "ims";
    }

    private static String sqlTestDatabase() {
        String result;
        try {
            result = SqlFactory.getProperties().getProperty(TEST_SQL_DATABASE_PROPERTY);
        }
        catch (BridgeDBException ex) {
            return ex.getMessage();
        }
        if (result != null) {
            return result.trim();
        }
        return "imstest";
    }

    private static String testSqlPassword() {
        String result;
        try {
            result = SqlFactory.getProperties().getProperty(TEST_SQL_PASSWORD_PROPERTY);
        }
        catch (BridgeDBException ex) {
            return ex.getMessage();
        }
        if (result != null) {
            return result.trim();
        }
        return "imstest";
    }

    private static String testSqlUser() {
        String result;
        try {
            result = SqlFactory.getProperties().getProperty(TEST_SQL_USER_PROPERTY);
        }
        catch (BridgeDBException ex) {
            return ex.getMessage();
        }
        if (result != null) {
            return result.trim();
        }
        return "imstest";
    }

    static boolean supportsIsValid() {
        return useMySQL;
    }

    static String getAutoIncrementCommand() {
        if (useMySQL) {
            return "AUTO_INCREMENT";
        }
        return "IDENTITY";
    }

    static boolean supportsMultipleInserts() {
        return useMySQL;
    }

    static boolean supportsLimit() {
        return useMySQL;
    }

    static boolean supportsTop() {
        return !useMySQL;
    }

    public static String configs() {
        try {
            if (useTest) {
                return "TEST: " + SqlFactory.sqlPort() + "/" + SqlFactory.sqlTestDatabase() + " user:" + SqlFactory.testSqlUser() + " password: " + SqlFactory.testSqlPassword();
            }
            return SqlFactory.sqlPort() + "/" + SqlFactory.sqlDatabase() + " user:" + SqlFactory.sqlUser() + " password:" + SqlFactory.sqlPassword();
        }
        catch (BridgeDBException ex) {
            return ex.getMessage();
        }
    }

    static boolean inSQLMode() {
        return useMySQL;
    }

    public static String engineSetting() {
        if (useTest) {
            try {
                String engine = SqlFactory.getProperties().getProperty(MYSQL_ENGINE_PROPERTY);
                if (engine == null || engine.isEmpty()) {
                    return "";
                }
                return " ENGINE = " + engine;
            }
            catch (BridgeDBException ex) {
                return "";
            }
        }
        return "";
    }
}

