/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.mysql;

import java.util.Set;
import org.apache.log4j.Logger;
import org.bridgedb.IDMapperException;
import org.bridgedb.pairs.CodeMapper;
import org.bridgedb.pairs.SyscodeBasedCodeMapper;
import org.bridgedb.sql.SQLIdMapper;
import org.bridgedb.sql.SQLListener;
import org.bridgedb.sql.TestSqlFactory;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="mysql")
public class MappingListenerTest
extends org.bridgedb.mapping.MappingListenerTest {
    static final Logger logger = Logger.getLogger(MappingListenerTest.class);
    static SQLIdMapper sqlIdMapper;

    @BeforeAll
    public static void setupIDMapper() throws BridgeDBException {
        connectionOk = false;
        TestSqlFactory.checkSQLAccess();
        ConfigReader.useTest();
        listener = new SQLListener(true);
        MappingListenerTest.loadData();
        sqlIdMapper = new SQLIdMapper(false, (CodeMapper)new SyscodeBasedCodeMapper());
        idMapper = sqlIdMapper;
        connectionOk = true;
        capabilities = idMapper.getCapabilities();
        logger.info((Object)"MySQL Setup successfull");
    }

    @Test
    @Tag(value="mysql")
    public void testMapIDOneToOne() throws IDMapperException {
        this.report("MapIDOneToOne");
        Set results = sqlIdMapper.mapID(map1xref1, DataSource2);
        Assertions.assertTrue((boolean)results.contains(map1xref2));
        Assertions.assertFalse((boolean)results.contains(map1xref3));
        Assertions.assertFalse((boolean)results.contains(map2xref1));
        Assertions.assertFalse((boolean)results.contains(map2xref2));
        Assertions.assertFalse((boolean)results.contains(map2xref2));
    }
}

