/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.sql;

import org.apache.log4j.Logger;
import org.bridgedb.sql.SQLAccess;
import org.bridgedb.sql.SqlFactory;
import org.bridgedb.utils.BridgeDBException;
import org.bridgedb.utils.ConfigReader;
import org.junit.Assume;

public abstract class TestSqlFactory {
    static final Logger logger = Logger.getLogger(TestSqlFactory.class);

    public static void checkSQLAccess() {
        ConfigReader.useTest();
        try {
            SQLAccess sqlAccess = SqlFactory.createTheSQLAccess();
            sqlAccess.getConnection();
        }
        catch (BridgeDBException ex) {
            logger.fatal((Object)"SKIPPPING tests due to Connection error.");
            System.err.println("**** SKIPPPING tests due to Connection error.");
            System.err.print("To run these test you must have ");
            if (SqlFactory.inSQLMode()) {
                System.err.println(" A SQL server running ");
            } else {
                System.err.println(" A Virtuoso server running ");
            }
            System.err.println("Configuration read from: BridgeDb.properties  " + SqlFactory.configs());
            logger.fatal((Object)("Configuration read from: BridgeDb.properties  " + SqlFactory.configs()));
            Assume.assumeTrue((boolean)false);
        }
    }
}

