/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.tools.batchmapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.Xref;
import org.bridgedb.bio.DataSourceTxt;

public class BatchMapper {
    public static void main(String[] args) {
        BatchMapper mapper = new BatchMapper();
        mapper.run(args);
    }

    public void printUsage() {
        String version = "";
        try {
            Properties props = new Properties();
            props.load(BridgeDb.class.getResourceAsStream("BridgeDb.properties"));
            version = props.getProperty("bridgedb.version") + " (r" + props.getProperty("REVISION") + ")";
        }
        catch (IOException ex) {
            version = ex.getMessage();
        }
        System.out.println("BatchMapper version " + version);
        System.out.print("BatchMapper is a tool for mapping biological identifiers.\nUsage:\n\tbatchmapper -ls \n\t\tList system codes \n or\n\tbatchmapper \n\t\t[-v|-vv] \n\t\t[-mm] \n\t\t[-g <gene database>] \n \t\t[-t <biomart text file>] \n \t\t[-i <input file>] \n\t\t-is <input system code or datasource name> \n\t\t-os <output system code or datasource name> \n\t\t[-o <output file>] \n\t\t[-c <input column, 0-based>]\n\t\t[-r <report file>] \n\nYou should specify at least one -g or -t option.\nMultiple -g or -t options will be combined transitively.\n");
    }

    private DataSource dsFromArg(String arg) {
        for (DataSource ds : DataSource.getDataSources()) {
            if (!arg.equals(ds.getSystemCode()) && !arg.equals(ds.getFullName())) continue;
            return ds;
        }
        System.out.println("WARNING: " + arg + " is not a standard system code or DataSource name");
        return DataSource.getExistingByFullName((String)arg);
    }

    public String parseArgs(Settings settings, String[] args) {
        for (int pos = 0; pos < args.length; ++pos) {
            File f;
            if (args[pos].equals("-ls")) {
                settings.mode = 1;
                continue;
            }
            if (args[pos].equals("-v")) {
                settings.verbose = 1;
                continue;
            }
            if (args[pos].equals("-vv")) {
                settings.verbose = 2;
                continue;
            }
            if (args[pos].equals("-g")) {
                if (++pos > args.length) {
                    return "File expected after -g";
                }
                f = new File(args[pos]);
                if (!f.exists()) {
                    return "File " + args[pos] + " does not exist";
                }
                settings.connectStrings.add("idmapper-pgdb:" + f.getAbsolutePath());
                continue;
            }
            if (args[pos].equals("-t")) {
                if (++pos > args.length) {
                    return "File expected after -t";
                }
                f = new File(args[pos]);
                if (!f.exists()) {
                    return "File " + args[pos] + " does not exist";
                }
                try {
                    settings.connectStrings.add("idmapper-text:" + f.toURL());
                    continue;
                }
                catch (MalformedURLException ex) {
                    return ex.getMessage();
                }
            }
            if (args[pos].equals("-i")) {
                if (++pos > args.length) {
                    return "File expected after -i";
                }
                settings.fInput = new File(args[pos]);
                if (settings.fInput.exists()) continue;
                return "File " + args[pos] + " does not exist";
            }
            if (args[pos].equals("-r")) {
                if (++pos > args.length) {
                    return "File expected after -r";
                }
                settings.fReport = new File(args[pos]);
                continue;
            }
            if (args[pos].equals("-c")) {
                ++pos;
                try {
                    settings.inputColumn = Integer.parseInt(args[pos]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    return ex.getMessage();
                }
            }
            if (args[pos].equals("-o")) {
                if (++pos > args.length) {
                    return "File expected after -o";
                }
                settings.fOutput = new File(args[pos]);
                continue;
            }
            if (args[pos].equals("-is")) {
                if (++pos > args.length) {
                    return "System code expected after -is";
                }
                settings.is = this.dsFromArg(args[pos]);
                continue;
            }
            if (args[pos].equals("-os")) {
                if (++pos > args.length) {
                    return "System code expected after -os";
                }
                settings.os = this.dsFromArg(args[pos]);
                continue;
            }
            if (args[pos].equals("-mm")) {
                settings.multiMap = 1;
                continue;
            }
            return "Unrecognized option " + args[pos];
        }
        if (settings.mode == 1) {
            if (settings.is != null || settings.os != null || settings.connectStrings.size() > 0 || settings.fInput != null || settings.fOutput != null || settings.inputColumn != 0 || settings.multiMap != 0 || settings.fReport != null) {
                return "-ls option can't be combined with -g, -t, -i, -is, -os, -o, -mm or -r options";
            }
        } else {
            if (settings.connectStrings.size() == 0) {
                return "Missing -t or -g options";
            }
            if (settings.is == null) {
                return "Missing -is option";
            }
            if (settings.os == null) {
                return "Missing -os option";
            }
        }
        return null;
    }

    public void reportSystemCodes() {
        ArrayList sortedList = new ArrayList();
        sortedList.addAll(DataSource.getDataSources());
        Collections.sort(sortedList, new Comparator<DataSource>(){

            @Override
            public int compare(DataSource a, DataSource b) {
                return a.getSystemCode().compareTo(b.getSystemCode());
            }
        });
        for (DataSource ds : sortedList) {
            System.out.printf("%4s %-20s %-40s\n", ds.getSystemCode(), ds.getFullName(), ds.getExample().getId());
        }
    }

    public void run(String[] args) {
        DataSourceTxt.init();
        Settings settings = new Settings();
        String error = this.parseArgs(settings, args);
        if (error != null) {
            System.err.println("Error: " + error);
            this.printUsage();
            System.exit(1);
        }
        try {
            Class.forName("org.bridgedb.file.IDMapperText");
            Class.forName("org.bridgedb.rdb.IDMapperRdb");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        if (settings.mode == 0) {
            Mapper mapper = new Mapper(settings.connectStrings, settings.fInput, settings.fOutput, settings.fReport, settings.is, settings.os, settings.inputColumn, settings.verbose, settings.multiMap);
            mapper.run();
        } else {
            this.reportSystemCodes();
        }
    }

    private static class Settings {
        File fInput = null;
        File fOutput = null;
        File fReport = null;
        List<String> connectStrings = new ArrayList<String>();
        DataSource is = null;
        DataSource os = null;
        int inputColumn = 0;
        int verbose = 0;
        int mode = 0;
        int multiMap = 0;

        private Settings() {
        }
    }

    public static class Mapper {
        private List<String> connections = null;
        private File fInput = null;
        private File fOutput = null;
        private File fReport = null;
        private DataSource is = null;
        private DataSource os = null;
        private int inputColumn = 0;
        private int verbose = 0;
        private int multiMap = 0;
        PrintStream report = System.out;
        private IDMapperStack gdb;
        private List<Xref> missing = new ArrayList<Xref>();
        private List<Xref> ambiguous = new ArrayList<Xref>();
        int totalLines = 0;
        int okLines = 0;

        public Mapper(List<String> connections, File fInput, File fOutput, File fReport, DataSource is, DataSource os, int inputColumn, int verbose, int multiMap) {
            this.connections = connections;
            this.fInput = fInput;
            this.fOutput = fOutput;
            this.fReport = fReport;
            this.is = is;
            this.os = os;
            this.inputColumn = inputColumn;
            this.verbose = verbose;
            this.multiMap = multiMap;
        }

        private void connectGdb() throws IDMapperException {
            this.gdb = new IDMapperStack();
            for (String connectionString : this.connections) {
                this.gdb.addIDMapper(connectionString);
            }
            this.gdb.setTransitive(true);
        }

        public void writeMapping() throws IOException, IDMapperException {
            String line;
            LineNumberReader reader = this.fInput != null ? new LineNumberReader(new FileReader(this.fInput)) : new LineNumberReader(new InputStreamReader(System.in));
            PrintWriter writer = this.fOutput != null ? new PrintWriter(new FileWriter(this.fOutput)) : new PrintWriter(System.out);
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split("\t");
                if (fields.length > this.inputColumn && fields[this.inputColumn] != null) {
                    Xref srcRef = new Xref(fields[this.inputColumn], this.is);
                    HashSet<Xref> srcSet = new HashSet<Xref>();
                    srcSet.add(srcRef);
                    Map mapresult = this.gdb.mapID(srcSet, new DataSource[]{this.os});
                    Set destRefs = (Set)mapresult.get(srcRef);
                    if (destRefs == null || destRefs.size() == 0) {
                        this.missing.add(srcRef);
                    } else if (destRefs.size() >= 2) {
                        this.ambiguous.add(srcRef);
                    }
                    if (destRefs != null && destRefs.size() > 0) {
                        ++this.okLines;
                        if (this.multiMap == 0) {
                            writer.print(destRefs.toArray(new Xref[0])[0].getId());
                        } else {
                            boolean first = true;
                            for (Xref ref : destRefs) {
                                if (first) {
                                    first = false;
                                } else {
                                    writer.print(" /// ");
                                }
                                writer.print(ref.getId());
                            }
                        }
                    }
                    ++this.totalLines;
                }
                writer.println("\t" + line);
            }
            reader.close();
            writer.close();
        }

        public void reportMapping() {
            this.report.println("Missing   : " + this.missing.size());
            this.report.println("Ambiguous : " + this.ambiguous.size());
            this.report.println("Ok        : " + this.okLines);
            this.report.println("           _______ +");
            this.report.println("Total     : " + this.totalLines);
            this.report.println();
            if (this.verbose >= 1) {
                int i;
                this.report.println("Missing id's:");
                for (i = 0; i < this.missing.size(); ++i) {
                    this.report.print(this.missing.get(i));
                    if (i < this.missing.size() - 1) {
                        this.report.print(", ");
                    }
                    if (i % 5 != 4) continue;
                    this.report.println();
                }
                this.report.println();
                this.report.println("Ambiguous id's:");
                for (i = 0; i < this.ambiguous.size(); ++i) {
                    this.report.print(this.ambiguous.get(i));
                    if (i < this.ambiguous.size() - 1) {
                        this.report.print(", ");
                    }
                    if (i % 5 != 4) continue;
                    this.report.println();
                }
                this.report.println();
            }
        }

        public void run() {
            try {
                if (this.fReport != null) {
                    this.report = new PrintStream(new FileOutputStream(this.fReport));
                }
                this.connectGdb();
                this.writeMapping();
                this.reportMapping();
                if (this.fReport != null) {
                    this.report.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (IDMapperException ex) {
                ex.printStackTrace();
            }
        }
    }
}

