/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.tools.qc;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.IDMapperException;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.rdb.construct.DataDerby;

public class PatternChecker {
    private Multiset<DataSource> allMisses = HashMultiset.create();
    private Multiset<DataSource> allTotals = HashMultiset.create();

    public void run(File f) throws SQLException, IDMapperException {
        String database = "" + f;
        DataDerby con = new DataDerby();
        Connection sqlcon = null;
        sqlcon = con.createConnection(database, 0);
        HashMultimap missExamples = HashMultimap.create();
        HashMultiset misses = HashMultiset.create();
        HashMultiset totals = HashMultiset.create();
        Map patterns = DataSourcePatterns.getPatterns();
        Statement st = sqlcon.createStatement();
        ResultSet rs = st.executeQuery("select id, code from datanode");
        while (rs.next()) {
            DataSource ds;
            String id = rs.getString(1);
            String syscode = rs.getString(2);
            if (!DataSource.systemCodeExists((String)syscode) || patterns.get(ds = DataSource.getExistingBySystemCode((String)syscode)) == null) continue;
            Set matches = DataSourcePatterns.getDataSourceMatches((String)id);
            if (!matches.contains(ds)) {
                if (missExamples.get((Object)ds).size() < 10) {
                    missExamples.put((Object)ds, (Object)id);
                }
                misses.add((Object)ds);
            }
            totals.add((Object)ds);
        }
        for (DataSource ds : totals.elementSet()) {
            int miss = misses.count((Object)ds);
            int total = totals.count((Object)ds);
            if (miss <= 0) continue;
            String severity = miss < total / 25 ? "WARNING" : "ERROR";
            System.out.println(severity + ": " + miss + "/" + total + " (" + miss * 100 / total + "%) ids do not match expected pattern for " + ds);
            System.out.println(severity + ": expected pattern is '" + patterns.get(ds) + "'");
            boolean first = true;
            for (String id : missExamples.get((Object)ds)) {
                System.out.print(first ? severity + ": aberrant ids are e.g. " : ", ");
                first = false;
                System.out.print("'" + id + "'");
            }
            System.out.println();
        }
        this.allMisses.addAll((Collection)misses);
        this.allTotals.addAll((Collection)totals);
    }

    private void finalReport() {
        System.out.println("=========== FINAL REPORT OF ID PATTERNS =============");
        for (DataSource ds : this.allTotals.elementSet()) {
            int miss = this.allMisses.count((Object)ds);
            int total = this.allTotals.count((Object)ds);
            System.out.println(ds + "\t" + miss + "\t" + total + "\t" + miss * 100 / total + "%");
        }
    }

    public static void main(String[] args) throws IDMapperException, SQLException {
        BioDataSource.init();
        PatternChecker checker = new PatternChecker();
        if (args.length == 0) {
            System.err.println("Argument expected: pgdb file to check");
            System.exit(1);
        }
        for (String arg : args) {
            File f = new File(arg);
            checker.run(f);
        }
        if (args.length > 1) {
            checker.finalReport();
        }
    }
}

